---------------------------------------------------------------------------------------
-- Carbonite Localization File
-- Copyright 2007-2010 Carbon Based Creations, LLC
---------------------------------------------------------------------------------------

NXlMapWGOverlayName = "lakewintergrasp"

if GetLocale() == "deDE" then		-- German

	BINDING_NAME_NxMAPTOGORIGINAL		= "Toggle Original Map"
	BINDING_NAME_NxMAPTOGNORMMAX		= "Toggle Normal or Max Map"
	BINDING_NAME_NxMAPTOGNONEMAX		= "Toggle None or Max Map"
	BINDING_NAME_NxMAPTOGNONENORM		= "Toggle None or Normal Map"
	BINDING_NAME_NxMAPSCALERESTORE	= "Restore Saved Map Scale"
	BINDING_NAME_NxMAPTOGMINIFULL		= "Toggle Full Size Minimap"
	BINDING_NAME_NxMAPTOGHERB			= "Toggle Herbs on map"
	BINDING_NAME_NxMAPTOGMINE			= "Toggle Mining on map"
	BINDING_NAME_NxTOGGLEFAV			= "Toggle Favorites"
	BINDING_NAME_NxTOGGLEGUIDE			= "Toggle Guide"
	BINDING_NAME_NxTOGGLEWAREHOUSE	= "Toggle Warehouse"
	BINDING_NAME_NxTOGGLEWATCHMINI	= "Toggle Watch List Minimize"
	BINDING_NAME_NxWATCHUSEITEM		= "Use Top Quest Watch Item"
	BINDING_NAME_NxMAPSKIPTARGET		= "Skip Current Target"

	NXLOADING			= "loading"
	NXLOAD_DONE			= "load done"

	NXlGas				= "Gas"
	NXlEXTRACTGAS		= "Gas extrahieren"
	NXlFISHING			= "Angeln"
	NXlHERBGATHERING	= "Kr\195\164utersammeln"
	NXlINCONFLICT		= "Umk\195\164mpft"
	NXlLEVELSPC			= "Stufe "
	NXlMINING			= "Bergbau"
	NXlOpening			= "\195\150ffnen"
	NXlOpeningNoText	= "\195\150ffnen - Kein Text"
	NXlGLOWCAP			= "Gl\195\188hkappe"
	NXlEverfrost		= "Immerfrostsplitter"

	NxlRiding			= "Reiten"

	NXlDurPattern = "^Haltbarkeit (%d+) / (%d+)"

	NXlClassLocToCap = {
		["Todesritter"] = "DEATHKNIGHT",
		["Druide"] = "DRUID",
		["Druidin"] = "DRUID",
		["J\195\164ger"] = "HUNTER",
		["J\195\164gerin"] = "HUNTER",
		["Magier"] = "MAGE",
		["Magierin"] = "MAGE",
		["Paladin"] = "PALADIN",
		["Priester"] = "PRIEST",
		["Priesterin"] = "PRIEST",
		["Schurke"] = "ROGUE",
		["Schurkin"] = "ROGUE",
		["Schamane"] = "SHAMAN",
		["Schamanin"] = "SHAMAN",
		["Hexenmeister"] = "WARLOCK",
		["Hexenmeisterin"] = "WARLOCK",
		["Krieger"] = "WARRIOR",
		["Kriegerin"] = "WARRIOR",
	}

	NXlBGMessages = {		-- Battleground messages. Menu text, message text
		"Incoming", "Inc",
		"Clear", "Clear",
		"Help", "Help",
		"Attack", "Attack",
		"Guard", "Guard",
		"Well Defended", "Well Defended",
		"Losing", "Losing",
	}

	NXlBGStatus			= "Report Status"

	NXlItemTypes = {
		ARMOR,
		"Verbrauchbar",
		"Beh\195\164lter",
		"Edelstein",
		"Glyphe",
		"Schl\195\188ssel",
		"Verschiedenes",
		"Projektil",
		"Quest",
		"K\195\182cher",
		"Reagenz",
		"Rezept",
		"Handwerkswaren",
		"Waffe",
	}

	NXlMapNames = { -- DE
		["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: Das Alte K\195\182nigreich",
		["Alterac Mountains"] = "Alteracgebirge",
		["Alterac Valley"] = "Alteractal",
		["Arathi Basin"] = "Arathibecken",
		["Arathi Highlands"] = "Arathihochland",
		["Ashenvale"] = "Eschental",
		["Auchenai Crypts"] = "Auchenaikrypta",
		["Azshara Crater"] = "Krater von Azshara",
		["Azuremyst Isle"] = "Azurmythosinsel",
		["Badlands"] = "\195\150dland",
		["Black Temple"] = "Der Schwarze Tempel",
		["Blackfathom Deeps"] = "Tiefschwarze Grotte",
		["Blackrock Depths"] = "Schwarzfelstiefen",
		["Blackrock Mountain"] = "Der Schwarzfels",
		["Blackrock Spire"] = "Schwarzfelsspitze",
		["Blackwing Lair"] = "Pechschwingenhort",
		["Blade's Edge Arena"] = "Arena des Schergrats",
		["Blade's Edge Mountains"] = "Schergrat",
		["Blasted Lands"] = "Verw\195\188stete Lande",
		["Bloodmyst Isle"] = "Blutmythosinsel",
		["Borean Tundra"] = "Boreanische Tundra",
		["Burning Steppes"] = "Brennende Steppe",
		["Caverns of Time"] = "H\195\182hlen der Zeit",
		["Champions' Hall"] = "Halle der Champions",
		["City"] = "Hauptst\195\164dte",
		["Crystalsong Forest"] = "Kristallsangwald",
		["Dalaran Arena"] = "Arena von Dalaran",
		["Darkshore"] = "Dunkelk\195\188ste",
		["Deadwind Pass"] = "Gebirgspass der Totenwinde",
		["Deeprun Tram"] = "Die Tiefenbahn",
		["Designer Island"] = "Designer-Insel",
		["Development Land"] = "Entwicklungsland",
		["Dire Maul"] = "D\195\188sterbruch",
		["Dragonblight"] = "Drachen\195\182de",
		["Drak'Tharon Keep"] = "Feste Drak'Tharon",
		["Duskwood"] = "D\195\164mmerwald",
		["Dustwallow Marsh"] = "D\195\188stermarschen",
		["Eastern Plaguelands"] = "\195\150stliche Pestl\195\164nder",
		["Elwynn Forest"] = "Wald von Elwynn",
		["Emerald Forest"] = "Smaragdwald",
		["Eversong Woods"] = "Immersangwald",
		["Eye of the Storm"] = "Auge des Sturms",
		["Felwood"] = "Teufelswald",
		["Force Interior"] = "Das Innere der Macht",
		["Gates of Ahn'Qiraj"] = "Tore von Ahn'Qiraj",
		["Ghostlands"] = "Geisterlande",
		["Gillijim's Isle"] = "Gillijims Insel",
		["GM Island"] = "GM-Insel",
		["Grizzly Hills"] = "Grizzlyh\195\188gel",
		["Gruul's Lair"] = "Gruuls Unterschlupf",
		["Hall of Legends"] = "Halle der Legenden",
		["Halls of Lightning"] = "Die Hallen der Blitze",
		["Halls of Stone"] = "Die Hallen des Steins",
		["Hellfire Citadel"] = "H\195\182llenfeuerzitadelle",
		["Hellfire Peninsula"] = "H\195\182llenfeuerhalbinsel",
		["Hellfire Ramparts"] = "H\195\182llenfeuerbollwerk",
		["Hillsbrad Foothills"] = "Vorgebirge des H\195\188gellands",
		["Howling Fjord"] = "Der heulende Fjord",
		["Hrothgar's Landing"] = "Hrothgars Landestelle",
		["Hyjal Past"] = "Hyjal der Vergangenheit",
		["Hyjal Summit"] = "Hyjalgipfel",
		["Icecrown"] = "Eiskrone",
		["Ironforge"] = "Eisenschmiede",
		["Island of Doctor Lapidis"] = "Insel des Doktor Lapidis",
		["Isle of Quel'Danas"] = "Insel von Quel'Danas",
		["Lordamere Lake"] = "Der Lordameresee",
		["Magisters' Terrace"] = "Terrasse der Magister",
		["Magtheridon's Lair"] = "Magtheridons Kammer",
		["Mana-Tombs"] = "Managruft",
		["Molten Core"] = "Geschmolzener Kern",
		["Moonglade"] = "Mondlichtung",
		["Nagrand Arena"] = "Arena von Nagrand",
		["Netherstorm"] = "Nethersturm",
		["Old Hillsbrad Foothills"] = "Vorgebirge des Alten H\195\188gellands",
		["Onyxia's Lair"] = "Onyxias Hort",
		["Outland"] = "Scherbenwelt",
		["Plaguelands: The Scarlet Enclave"] = "Pestl\195\164nder: Die Scharlachrote Enklave",
		["Programmer Isle"] = "Programmierer-Insel",
		["Quel'thalas"] = "Quel'Thalas",
		["Ragefire Chasm"] = "Der Flammenschlund",
		["Razorfen Downs"] = "H\195\188gel der Klingenhauer",
		["Razorfen Kraul"] = "Kral der Klingenhauer",
		["Redridge Mountains"] = "Rotkammgebirge",
		["Reuse Me 7"] = "Benutzt mich wieder 7",
		["Ruins of Ahn'Qiraj"] = "Ruinen von Ahn'Qiraj",
		["Ruins of Lordaeron"] = "Ruinen von Lordaeron",
		["Scarlet Monastery"] = "Das Scharlachrote Kloster",
		["Searing Gorge"] = "Sengende Schlucht",
		["Serpentshrine Cavern"] = "H\195\182hle des Schlangenschreins",
		["Sethekk Halls"] = "Sethekkhallen",
		["Shadow Labyrinth"] = "Schattenlabyrinth",
		["Shadowfang Keep"] = "Burg Schattenfang",
		["Shadowmoon Valley"] = "Schattenmondtal",
		["Shattrath City"] = "Shattrath",
		["Sholazar Basin"] = "Sholazarbecken",
		["Silvermoon City"] = "Silbermond",
		["Silverpine Forest"] = "Silberwald",
		["Southfury River"] = "Der S\195\188dstrom",
		["Stonetalon Mountains"] = "Steinkrallengebirge",
		["Stormwind City"] = "Sturmwind",
		["Strand of the Ancients"] = "Strand der Uralten",
		["Stranglethorn Vale"] = "Schlingendorntal",
		["Sunken Temple"] = "Versunkener Tempel",
		["Sunwell Plateau"] = "Sonnenbrunnenplateau",
		["Swamp of Sorrows"] = "S\195\188mpfe des Elends",
		["Tempest Keep"] = "Festung der St\195\188rme",
		["Terokkar Forest"] = "W\195\164lder von Terokkar",
		["Thandol Span"] = "Thandol\195\188bergang",
		["The Arcatraz"] = "Die Arkatraz",
		["The Barrens"] = "Brachland",
		["The Black Morass"] = "Der schwarze Morast",
		["The Blood Furnace"] = "Der Blutkessel",
		["The Botanica"] = "Die Botanika",
		["The Culling of Stratholme"] = "Das Ausmerzen von Stratholme",
		["The Deadmines"] = "Die Todesminen",
		["The Exodar"] = "Die Exodar",
		["The Eye of Eternity"] = "Das Auge der Ewigkeit",
		["The Forbidding Sea"] = "Das verbotene Meer",
		["The Frozen Sea"] = "Die gefrorene See",
		["The Great Sea"] = "Das gro\195\159e Meer",
		["The Hinterlands"] = "Hinterland",
		["The Mechanar"] = "Die Mechanar",
		["The Nexus"] = "Der Nexus",
		["The North Sea"] = "Das Nordmeer",
		["The Obsidian Sanctum"] = "Das Obsidiansanktum",
		["The Oculus"] = "Das Oculus",
		["The Ring of Valor"] = "Der Ring der Ehre",
		["The Shattered Halls"] = "Die zerschmetterten Hallen",
		["The Slave Pens"] = "Die Sklavenunterk\195\188nfte",
		["The Steamvault"] = "Die Dampfkammer",
		["The Stockade"] = "Das Verlies",
		["The Storm Peaks"] = "Die Sturmgipfel",
		["The Temple of Atal'Hakkar"] = "Der Tempel von Atal'Hakkar",
		["The Underbog"] = "Der Tiefensumpf",
		["The Veiled Sea"] = "Das verh\195\188llte Meer",
		["The Verdant Fields"] = "Die saftgr\195\188nen Felder",
		["The Violet Hold"] = "Die Violette Festung",
		["Thoradin's Wall"] = "Thoradinswall",
		["Thousand Needles"] = "Tausend Nadeln",
		["Thunder Bluff"] = "Donnerfels",
		["Tirisfal Glades"] = "Tirisfal",
		["Twisting Nether"] = "Wirbelnder Nether",
		["Undercity"] = "Unterstadt",
		["Un'Goro Crater"] = "Krater von Un'Goro",
		["Utgarde Keep"] = "Burg Utgarde",
		["Utgarde Pinnacle"] = "Turm Utgarde",
		["Vault of Archavon"] = "Archavons Kammer",
		["Vordrassil's Tears"] = "Vordrassils Tr\195\164nen",
		["Wailing Caverns"] = "Die H\195\182hlen des Wehklagens",
		["Warsong Gulch"] = "Kriegshymnenschlucht",
		["Western Plaguelands"] = "Westliche Pestl\195\164nder",
		["Wetlands"] = "Sumpfland",
		["Wintergrasp"] = "Tausendwintersee",
		["Winterspring"] = "Winterquell",
		["Zangarmarsh"] = "Zangarmarschen",
		["Isle of Conquest"] = "Insel der Eroberung",	-- 3.2
		["Trial of the Champion"] = "Pr\195\188fung des Kreuzfahrers",
		["Trial of the Crusader"] = "Pr\195\188fung des Champions",
	}
	NXlMapSubNames = {
		["Dalaran"] = {
			["Zur Zauberkr\195\164he"] = 2,
			["Kreis der M\195\164chte"] = 2,
			["Der Schwarzmarkt"] = 2,
			["Die Schattenseite"] = 2,
		}
	}
	NXlTaxiNames = { -- DE
		["Acherus: The Ebon Hold"] = "Acherus: Die Schwarze Festung",
		["Aerie Peak"] = "Nistgipfel",
		["Agmar's Hammer"] = "Agmars Hammer",
		["Allerian Stronghold"] = "Allerias Feste",
		["Altar of Sha'tar"] = "Altar der Sha'tar",
		["Amber Ledge"] = "Bernsteinfl\195\182z",
		["Amberpine Lodge"] = "Ammertannh\195\188tte",
		["Apothecary Camp"] = "Apothekerlager",
		["Argent Stand"] = "Argentumwache",
		["Argent Tournament Grounds"] = "Argentumturnierplatz",
		["Beryl Point"] = "Beryllspitze",
		["Blood Watch"] = "Blutwacht",
		["Bloodvenom Post"] = "Blutgiftposten",
		["Booty Bay"] = "Beutebucht",
		["Borean Tundra"] = "Boreanische Tundra",
		["Bor'gorok Outpost"] = "Bor'goroks Au\195\159enposten",
		["Bouldercrag's Refuge"] = "Bergfels' Zuflucht",
		["Brackenwall Village"] = "Brackenwall",
		["Camp Onequah"] = "Onequah",
		["Camp Winterhoof"] = "Lager der Winterhufe",
		["Cenarion Hold"] = "Burg Cenarius",
		["Chillwind Camp"] = "Zugwindlager",
		["Coldarra Ledge"] = "Kaltarrar\195\188cken",
		["Conquest Hold"] = "Burg Siegeswall",
		["Cosmowrench"] = "Kosmozang",
		["Crossroads"] = "Das Wegekreuz",
		["Crown Guard Tower"] = "Turm der Kronenwache",
		["Crusaders' Pinnacle"] = "Kreuzfahrerturm",
		["Darkshire"] = "Dunkelhain",
		["Death's Rise"] = "Todesanh\195\182he",
		["Eastern Plaguelands"] = "Die \195\182stlichen Pestl\195\164nder",
		["Eastwall Tower"] = "Ostwallturm",
		["Ebon Watch"] = "Schwarze Wacht",
		["Emerald Sanctuary"] = "Smaragdrefugium",
		["Evergrove"] = "Der ewige Hain",
		["Everlook"] = "Ewige Warte",
		["Falcon Watch"] = "Falkenwacht",
		["Feathermoon"] = "Mondfederfeste",
		["Filming"] = "Filmen",
		["Fishing Village"] = "Fischerdorf",
		["Fizzcrank Airstrip"] = "Landebahn Kurbelzisch",
		["Flame Crest"] = "Flammenkamm",
		["Fordragon Hold"] = "Feste Fordragon",
		["Forest Song"] = "Waldeslied",
		["Freewind Post"] = "Freiwindposten",
		["Frosthold"] = "Eisfestung",
		["Frostwolf Keep"] = "Burg Frostwolf",
		["Generic"] = "Allgemein",
		["Grizzly Hills"] = "Grizzlyh\195\188gel",
		["Grom'arsh Crash-Site"] = "Absturzstelle Grom'ash",
		["Hellfire Peninsula"] = "H\195\182llenfeuerhalbinsel",
		["Honor Hold"] = "Ehrenfeste",
		["Ironforge"] = "Eisenschmiede",
		["Kor'koron Vanguard"] = "Vorposten der Kor'kron",
		["Lakeshire"] = "Seenhain",
		["Light's Breach"] = "Lichtbresche",
		["Light's Hope Chapel"] = "Kapelle des hoffnungsvollen Lichts",
		["Marshal's Refuge"] = "Marschalls Zuflucht",
		["Menethil Harbor"] = "Hafen von Menethil",
		["Mok'Nathal Village"] = "Dorf der Mok'Nathal",
		["Moonglade"] = "Mondlichtung",
		["Morgan's Vigil"] = "Morgans Wacht",
		["Mudsprocket"] = "Morastwinkel",
		["Nesingwary Base Camp"] = "Nesingwarys Basislager",
		["Nethergarde Keep"] = "Burg Nethergarde",
		["New Agamand"] = "Neu-Agamand",
		["Nighthaven"] = "Nachthafen",
		["Nijel's Point"] = "Die Nijelspitze",
		["Northpass Tower"] = "Nordpassturm",
		["Northshire Abbey"] = "Abtei von Nordhain",
		["Orebor Harborage"] = "Oreborzuflucht",
		["Plaguewood Tower"] = "Pestwaldturm",
		["Programmer Isle"] = "Programmierer-Insel",
		["Ratchet"] = "Ratschet",
		["Rebel Camp"] = "Rebellenlager",
		["Refuge Pointe"] = "Die Zuflucht",
		["Revantusk Village"] = "Dorf der Bruchhauer",
		["River's Heart"] = "Flussnabel",
		["Ruined City Post 01"] = "Ruinenstadt 01",
		["Rut'theran Village"] = "Rut'theran",
		["Sanctum of the Stars"] = "Sanktum der Sterne",
		["Sentinel Hill"] = "Sp\195\164herkuppe",
		["Shadowmoon Village"] = "Schattenmond",
		["Shadowprey Village"] = "Schattenflucht",
		["Shatter Point"] = "Tr\195\188mmerposten",
		["Shattered Sun Staging Area"] = "Sammelpunkt der Zerschmetterten Sonne",
		["Silvermoon City"] = "Silbermond",
		["Southshore"] = "S\195\188derstade",
		["Spinebreaker Ridge"] = "R\195\188ckenbrechergrat",
		["Splintertree Post"] = "Splitterholzposten",
		["Star's Rest"] = "Sternenruh",
		["Stonard"] = "Steinard",
		["Stonebreaker Hold"] = "Steinbrecherfeste",
		["Stonetalon Peak"] = "Steinkrallengipfel",
		["Stormwind"] = "Sturmwind",
		["Sun Rock Retreat"] = "Sonnenfels",
		["Sunreaver's Command"] = "Sonnenh\195\164schers Schar",
		["Swamprat Post"] = "Sumpfrattenposten",
		["Talonbranch Glade"] = "Nachtlaublichtung",
		["Talrendis Point"] = "Talrendisspitze",
		["Tarren Mill"] = "Tarrens M\195\188hle",
		["Taunka'le Village"] = "Taunka'le",
		["Temple of Telhamat"] = "Tempel von Telhamat",
		["The Argent Stand"] = "Argentumwache",
		["The Argent Vanguard"] = "Die Argentumvorhut",
		["The Exodar"] = "Die Exodar",
		["The Sepulcher"] = "Das Grabmal",
		["The Shadow Vault"] = "Das Schattengew\195\182lbe",
		["The Stormspire"] = "Die Sturms\195\164ule",
		["Thorium Point"] = "Thoriumspitze",
		["Thunder Bluff"] = "Donnerfels",
		["Thunderlord Stronghold"] = "Donnerfeste",
		["Toshley's Station"] = "Toshleys Station",
		["Tranquillien"] = "Tristessa",
		["Transitus Shield"] = "Transitusschild",
		["Undercity"] = "Unterstadt",
		["Valgarde Port"] = "Hafen von Valgarde",
		["Valiance Keep"] = "Valianzfeste",
		["Valiance Landing Camp"] = "Valianzlager",
		["Vengeance Landing"] = "Hafen der Vergeltung",
		["Venomspite"] = "Gallgrimm",
		["Warsong Camp"] = "Kriegshymnenlager",
		["Warsong Hold"] = "Kriegshymnenfeste",
		["Westfall Brigade"] = "Westfallbrigade",
		["Westguard Keep"] = "Westwacht",
		["Wildhammer Stronghold"] = "Wildhammerfeste",
		["Windrunner's Overlook"] = "Windl\195\164ufers Warte",
		["Wintergarde Keep"] = "Feste Wintergarde",
		["Wyrmrest Temple"] = "Wyrmruhtempel",
		["Zoram'gar Outpost"] = "Au\195\159enposten von Zoram'gar",
	}

elseif GetLocale() == "frFR" then	-- French

	BINDING_NAME_NxMAPTOGORIGINAL		= "Toggle Original Map"
	BINDING_NAME_NxMAPTOGNORMMAX		= "Toggle Normal or Max Map"
	BINDING_NAME_NxMAPTOGNONEMAX		= "Toggle None or Max Map"
	BINDING_NAME_NxMAPTOGNONENORM		= "Toggle None or Normal Map"
	BINDING_NAME_NxMAPSCALERESTORE	= "Restore Saved Map Scale"
	BINDING_NAME_NxMAPTOGMINIFULL		= "Toggle Full Size Minimap"
	BINDING_NAME_NxMAPTOGHERB			= "Toggle Herbs on map"
	BINDING_NAME_NxMAPTOGMINE			= "Toggle Mining on map"
	BINDING_NAME_NxTOGGLEFAV			= "Toggle Favorites"
	BINDING_NAME_NxTOGGLEGUIDE			= "Toggle Guide"
	BINDING_NAME_NxTOGGLEWAREHOUSE	= "Toggle Warehouse"
	BINDING_NAME_NxTOGGLEWATCHMINI	= "Toggle Watch List Minimize"
	BINDING_NAME_NxWATCHUSEITEM		= "Use Top Quest Watch Item"
	BINDING_NAME_NxMAPSKIPTARGET		= "Skip Current Target"

	NXLOADING			= "loading"
	NXLOAD_DONE			= "load done"

	NXlGas				= "Gaz"
	NXlEXTRACTGAS		= "Extraction de gaz"
	NXlFISHING			= "P\195\170che"
	NXlHERBGATHERING	= "Cueillette"
	NXlINCONFLICT		= "Territoire disput\195\169"
	NXlLEVELSPC			= "Niveau "
	NXlMINING			= "Minage"
	NXlOpening			= "Ouverture"
	NXlOpeningNoText	= "Ouverture - pas de texte"
	NXlGLOWCAP			= "Chapeluisant"
	NXlEverfrost		= "Morceau de permagivre"

	NxlRiding			= "Monte"

	NXlDurPattern = "^Durabilit\195\169 (%d+) / (%d+)"

	NXlClassLocToCap = {
		["Chevalier de la mort"] = "DEATHKNIGHT",
		["Druide"] = "DRUID",
		["Druidesse"] = "DRUID",
		["Chasseur"] = "HUNTER",
		["Chasseresse"] = "HUNTER",
		["Mage"] = "MAGE",
		["Paladin"] = "PALADIN",
		["Pr\195\170tre"] = "PRIEST",
		["Pr\195\170tresse"] = "PRIEST",
		["Voleur"] = "ROGUE",
		["Voleuse"] = "ROGUE",
		["Chaman"] = "SHAMAN",
		["Chamane"] = "SHAMAN",
		["D\195\169moniste"] = "WARLOCK",
		["Guerrier"] = "WARRIOR",
		["Guerri\195\168re"] = "WARRIOR",
	}

	NXlBGMessages = {		-- Battleground messages. Menu text, message text
		"Incoming", "Inc",
		"Clear", "Clear",
		"Help", "Help",
		"Attack", "Attack",
		"Guard", "Guard",
		"Well Defended", "Well Defended",
		"Losing", "Losing",
	}

	NXlItemTypes = {
		ARMOR,
		"Consommable",
		"Conteneur",
		"Gemme",
		"Glyphe",
		"Cl\195\169",
		"Divers",
		"Qu\195\170te",
		"Carquois",
		"Composant",
		"Recette",
		"Artisanat",
		"Arme",
	}

	NXlBGStatus			= "Report Status"

	NXlMapNames = { -- FR
		["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet\194\160: l'Ancien royaume",
		["Alterac Mountains"] = "Montagnes d'Alterac",
		["Alterac Valley"] = "Vall\195\169e d'Alterac",
		["Arathi Basin"] = "Bassin d'Arathi",
		["Arathi Highlands"] = "Hautes-terres d'Arathi",
		["Ashenvale"] = "Orneval",
		["Auchenai Crypts"] = "Cryptes Auchena\195\175",
		["Azjol-Nerub"] = "Azjol-N\195\169rub",
		["Azshara Crater"] = "Crat\195\168re d'Azshara",
		["Azuremyst Isle"] = "\195\142le de Brume-azur",
		["Badlands"] = "Terres ingrates",
		["Black Temple"] = "Temple noir",
		["Blackfathom Deeps"] = "Profondeurs de Brassenoire",
		["Blackrock Depths"] = "Profondeurs de Rochenoire",
		["Blackrock Mountain"] = "Mont Rochenoire",
		["Blackrock Spire"] = "Pic Rochenoire",
		["Blackwing Lair"] = "Repaire de l'Aile noire",
		["Blade's Edge Arena"] = "Ar\195\168ne des Tranchantes",
		["Blade's Edge Mountains"] = "Les Tranchantes",
		["Blasted Lands"] = "Terres foudroy\195\169es",
		["Bloodmyst Isle"] = "\195\142le de Brume-sang",
		["Borean Tundra"] = "Toundra Bor\195\169enne",
		["Brian and Pat Test"] = "Test de Brian et Pat",
		["Burning Steppes"] = "Steppes ardentes",
		["Caverns of Time"] = "Grottes du temps",
		["Champions' Hall"] = "Hall des Champions",
		["City"] = "Capitales",
		["Crystalsong Forest"] = "For\195\170t du Chant de cristal",
		["Dalaran Arena"] = "Ar\195\168ne de Dalaran",
		["Darkshore"] = "Sombrivage",
		["Deadwind Pass"] = "D\195\169fil\195\169 de Deuillevent",
		["Deeprun Tram"] = "Tram des profondeurs",
		["Designer Island"] = "\195\142le des concepteurs",
		["Desolace"] = "D\195\169solace",
		["Development Land"] = "Terrain en d\195\169veloppement",
		["Dire Maul"] = "Hache-tripes",
		["DO NOT USE"] = "NE PAS UTILISER",
		["Dragonblight"] = "D\195\169solation des dragons",
		["Drak'Tharon Keep"] = "Donjon de Drak'Tharon",
		["Duskwood"] = "Bois de la P\195\169nombre",
		["Dustwallow Marsh"] = "Mar\195\169cage d'\195\130prefange",
		["Eastern Plaguelands"] = "Maleterres de l'est",
		["Elwynn Forest"] = "For\195\170t d'Elwynn",
		["Emerald Forest"] = "For\195\170t d'\195\169meraude",
		["Eversong Woods"] = "Bois des Chants \195\169ternels",
		["Eye of the Storm"] = "L'\197\146il du cyclone",
		["Felwood"] = "Gangrebois",
		["Feralas"] = "F\195\169ralas",
		["Force Interior"] = "Force int\195\169rieure",
		["Gates of Ahn'Qiraj"] = "Portes d'Ahn'Qiraj",
		["Ghostlands"] = "Les Terres fant\195\180mes",
		["Gillijim's Isle"] = "\195\142le de Gillijim",
		["GM Island"] = "\195\142le des MJ",
		["Grizzly Hills"] = "Les Grisonnes",
		["Gruul's Lair"] = "Repaire de Gruul",
		["Hall of Legends"] = "Hall des L\195\169gendes",
		["Halls of Lightning"] = "Les salles de Foudre",
		["Halls of Stone"] = "Les salles de Pierre",
		["Hellfire Citadel"] = "Citadelle des Flammes infernales",
		["Hellfire Peninsula"] = "P\195\169ninsule des Flammes infernales",
		["Hellfire Ramparts"] = "Remparts des Flammes infernales",
		["Hillsbrad Foothills"] = "Contreforts de Hautebrande",
		["Howling Fjord"] = "Fjord Hurlant",
		["Hrothgar's Landing"] = "Accostage de Hrothgar",
		["Hyjal Past"] = "Pass\195\169 d'Hyjal",
		["Hyjal Summit"] = "Sommet d'Hyjal",
		["Icecrown"] = "La Couronne de glace",
		["Ironforge"] = "Forgefer",
		["Island of Doctor Lapidis"] = "\195\142le du docteur Lapidis",
		["Isle of Quel'Danas"] = "\195\142le de Quel'Danas",
		["Lordamere Lake"] = "Lac Lordamere",
		["Magisters' Terrace"] = "Terrasse des Magist\195\168res",
		["Magtheridon's Lair"] = "Le repaire de Magtheridon",
		["Mana-Tombs"] = "Tombes-mana",
		["Molten Core"] = "C\197\147ur du Magma",
		["Moonglade"] = "Reflet-de-Lune",
		["Nagrand Arena"] = "Ar\195\168ne de Nagrand",
		["Netherstorm"] = "Raz-de-N\195\169ant",
		["Nine"] = "Neuf",
		["Old Hillsbrad Foothills"] = "Contreforts de Hautebrande d'antan",
		["Onyxia's Lair"] = "Repaire d'Onyxia",
		["Outland"] = "Outreterre",
		["Plaguelands: The Scarlet Enclave"] = "Maleterres : l'enclave \195\137carlate",
		["Programmer Isle"] = "\195\142le des programmeurs",
		["Ragefire Chasm"] = "Gouffre de Ragefeu",
		["Razorfen Downs"] = "Souilles de Tranchebauge",
		["Razorfen Kraul"] = "Kraal de Tranchebauge",
		["Redridge Mountains"] = "Les Carmines",
		["Ruins of Ahn'Qiraj"] = "Ruines d'Ahn'Qiraj",
		["Ruins of Lordaeron"] = "Ruines de Lordaeron",
		["Scarlet Monastery"] = "Monast\195\168re \195\169carlate",
		["Searing Gorge"] = "Gorge des Vents br\195\187lants",
		["Serpentshrine Cavern"] = "Caverne du sanctuaire du Serpent",
		["Sethekk Halls"] = "Les salles des Sethekk",
		["Shadow Labyrinth"] = "Labyrinthe des ombres",
		["Shadowfang Keep"] = "Donjon d'Ombrecroc",
		["Shadowmoon Valley"] = "Vall\195\169e d'Ombrelune",
		["Shattrath City"] = "Shattrath",
		["Sholazar Basin"] = "Bassin de Sholazar",
		["Silvermoon City"] = "Lune-d'argent",
		["Silverpine Forest"] = "For\195\170t des Pins argent\195\169s",
		["South Seas UNUSED"] = "Mers du Sud",
		["Southfury River"] = "Fleuve Furie-du-Sud",
		["Stonetalon Mountains"] = "Les Serres-Rocheuses",
		["Stormwind City"] = "Hurlevent",
		["Strand of the Ancients"] = "Rivage des Anciens",
		["Stranglethorn Vale"] = "Vall\195\169e de Strangleronce",
		["Sunken Temple"] = "Temple englouti",
		["Sunwell Plateau"] = "Plateau du Puits de soleil",
		["Swamp of Sorrows"] = "Marais des Chagrins",
		["Tempest Keep"] = "Donjon de la Temp\195\170te",
		["Terokkar Forest"] = "For\195\170t de Terokkar",
		["Testing"] = "Test",
		["Thandol Span"] = "Viaduc de Thandol",
		["The Arcatraz"] = "L'Arcatraz",
		["The Barrens"] = "Les Tarides",
		["The Black Morass"] = "Le Noir Mar\195\169cage",
		["The Blood Furnace"] = "La Fournaise du sang",
		["The Botanica"] = "La Botanica",
		["The Culling of Stratholme"] = "L'\195\137puration de Stratholme",
		["The Deadmines"] = "Les Mortemines",
		["The Exodar"] = "L'Exodar",
		["The Eye of Eternity"] = "L'\197\146il de l'\195\169ternit\195\169",
		["The Forbidding Sea"] = "La Mer interdite",
		["The Frozen Sea"] = "La mer Gel\195\169e",
		["The Great Sea"] = "La Grande mer",
		["The Hinterlands"] = "Les Hinterlands",
		["The Mechanar"] = "Le M\195\169chanar",
		["The Nexus"] = "Le Nexus",
		["The North Sea"] = "La mer Bor\195\169ale",
		["The Obsidian Sanctum"] = "Le sanctum Obsidien",
		["The Oculus"] = "L'Oculus",
		["The Ring of Valor"] = "L'Ar\195\168ne des valeureux",
		["The Shattered Halls"] = "Les Salles bris\195\169es",
		["The Slave Pens"] = "Les enclos aux esclaves",
		["The Steamvault"] = "Le Caveau de la vapeur",
		["The Stockade"] = "La Prison",
		["The Storm Peaks"] = "Les pics Foudroy\195\169s",
		["The Temple of Atal'Hakkar"] = "Le temple d'Atal'Hakkar",
		["The Underbog"] = "La Basse-tourbi\195\168re",
		["The Veiled Sea"] = "La Mer voil\195\169e",
		["The Verdant Fields"] = "Les Champs verdoyants",
		["The Violet Hold"] = "Le fort Pourpre",
		["Thoradin's Wall"] = "Mur de Thoradin",
		["Thousand Needles"] = "Mille pointes",
		["Thunder Bluff"] = "Les Pitons du Tonnerre",
		["Tirisfal Glades"] = "Clairi\195\168res de Tirisfal",
		["Twisting Nether"] = "Le N\195\169ant distordu",
		["Undercity"] = "Fossoyeuse",
		["Un'Goro Crater"] = "Crat\195\168re d'Un'Goro",
		["Unused Ironcladcove"] = "Crique du cuirass\195\169",
		["UNUSED Stonewrought Pass"] = "Passage de Formepierre",
		["Unused The Deadmines 002"] = "Les Mortemines",
		["Utgarde Keep"] = "Donjon d'Utgarde",
		["Utgarde Pinnacle"] = "Cime d'Utgarde",
		["Vault of Archavon"] = "Caveau d'Archavon",
		["Vordrassil's Tears"] = "Larmes de Vordrassil",
		["Wailing Caverns"] = "Cavernes des lamentations",
		["Warsong Gulch"] = "Goulet des Chanteguerres",
		["Western Plaguelands"] = "Maleterres de l'ouest",
		["Westfall"] = "Marche de l'Ouest",
		["Wetlands"] = "Les Paluns",
		["Wintergrasp"] = "Joug-d'hiver",
		["Winterspring"] = "Berceau-de-l'Hiver",
		["Zangarmarsh"] = "Mar\195\169cage de Zangar",
		["Isle of Conquest"] = "\195\142le des Conqu\195\169rants",
		["Trial of the Champion"] = "L'\195\169preuve du crois\195\169",
		["Trial of the Crusader"] = "L'\195\169preuve du champion",
	}
	NXlMapSubNames = {	-- Translate!
		["Dalaran"] = {
			["Cantrips & Crows"] = 2,
			["Circle of Wills"] = 2,
			["The Black Market"] = 2,
			["The Underbelly"] = 2,
		}
	}
	NXlTaxiNames = { -- FR
		["Acherus: The Ebon Hold"] = "Ach\195\169rus\194\160: le fort d'\195\137b\195\168ne",
		["Aerie Peak"] = "Nid-de-l'Aigle",
		["Agmar's Hammer"] = "Marteau d'Agmar",
		["Allerian Stronghold"] = "Bastion all\195\169rien",
		["Altar of Sha'tar"] = "Autel de Sha'tar",
		["Amber Ledge"] = "Escarpement d'Ambre",
		["Amberpine Lodge"] = "G\195\174te Ambrepin",
		["Apothecary Camp"] = "Camp des Apothicaires",
		["Area 52"] = "Zone 52",
		["Argent Stand"] = "S\195\169jour d'Argent",
		["Beryl Point"] = "Pointe de B\195\169ryl",
		["Blood Watch"] = "Guet du sang",
		["Bloodvenom Post"] = "Poste de la V\195\169n\195\169neuse",
		["Booty Bay"] = "Baie-du-Butin",
		["Borean Tundra"] = "Toundra Bor\195\169enne",
		["Bor'gorok Outpost"] = "Avant-poste Bor'gorok",
		["Bouldercrag's Refuge"] = "Refuge de Rochecombe",
		["Brackenwall Village"] = "Mur-de-Foug\195\168res",
		["Camp Winterhoof"] = "Camp Sabot-d'hiver",
		["Cenarion Hold"] = "Fort c\195\169narien",
		["Chillwind Camp"] = "Camp du Noro\195\174t",
		["Coldarra"] = "Frimarra",
		["Coldarra Ledge"] = "Escarpement de Frimarra",
		["Conquest Hold"] = "Bastion de la Conqu\195\170te",
		["Cosmowrench"] = "Cosmovrille",
		["Crossroads"] = "La Crois\195\169e",
		["Crown Guard Tower"] = "Tour de garde de la couronne",
		["Crusaders' Pinnacle"] = "Cime des Crois\195\169s",
		["Darkshire"] = "Sombre-comt\195\169",
		["Death's Rise"] = "Cime de la Mort",
		["Eastern Plaguelands"] = "Maleterres de l'est",
		["Eastwall Tower"] = "Tour du Mur d'est",
		["Ebon Watch"] = "Guet d'\195\137b\195\168ne",
		["Emerald Sanctuary"] = "Sanctuaire d'\195\169meraude",
		["Evergrove"] = "Bosquet \195\169ternel",
		["Everlook"] = "Long-guet",
		["Falcon Watch"] = "Guet de l'\195\169pervier",
		["Feathermoon"] = "Pennelune",
		["Filming"] = "On filme",
		["Fishing Village"] = "Village de p\195\170cheurs",
		["Fizzcrank Airstrip"] = "Piste d'atterrissage de Spumelevier",
		["Flame Crest"] = "Corniche des flammes",
		["Fordragon Hold"] = "Bastion Fordragon",
		["Forest Song"] = "Chant des for\195\170ts",
		["Fort Wildervar"] = "Fort Hardivar",
		["Freewind Post"] = "Poste de Librevent",
		["Frosthold"] = "Fort du Givre",
		["Frostwolf Keep"] = "Donjon Loup-de-givre",
		["Generic"] = "G\195\169n\195\169rique",
		["Grizzly Hills"] = "Les Grisonnes",
		["Grom'arsh Crash-Site"] = "Point d'impact de Grom'arsh",
		["Hammerfall"] = "Tr\195\169pas-d'Orgrim",
		["Hellfire Peninsula"] = "P\195\169ninsule des Flammes infernales",
		["Honor Hold"] = "Bastion de l'Honneur",
		["Ironforge"] = "Forgefer",
		["Kor'koron Vanguard"] = "Avant-garde Kor'kron",
		["Lakeshire"] = "Comt\195\169-du-lac",
		["Light's Breach"] = "La Br\195\168che de Lumi\195\168re",
		["Light's Hope Chapel"] = "Chapelle de l'Espoir de Lumi\195\168re",
		["Marshal's Refuge"] = "Refuge des Marshal",
		["Menethil Harbor"] = "Port de Menethil",
		["Mok'Nathal Village"] = "Mok'Nathal",
		["Moonglade"] = "Reflet-de-Lune",
		["Morgan's Vigil"] = "Veille de Morgan",
		["Mudsprocket"] = "Bourbe-\195\160-brac",
		["Nesingwary Base Camp"] = "Camp de base de Nesingwary",
		["Nethergarde Keep"] = "Rempart-du-N\195\169ant",
		["New Agamand"] = "Nouvelle-Agamand",
		["Nighthaven"] = "Havrenuit",
		["Nijel's Point"] = "Combe de Nijel",
		["Northpass Tower"] = "Tour du Col du nord",
		["Northshire Abbey"] = "Abbaye de Comt\195\169-du-nord",
		["Orebor Harborage"] = "Havre d'Orebor",
		["Plaguewood Tower"] = "Tour de Pestebois",
		["Programmer Isle"] = "\195\142le des programmeurs",
		["Ratchet"] = "Cabestan",
		["Rebel Camp"] = "Camp rebelle",
		["Refuge Pointe"] = "Refuge de l'Orni\195\168re",
		["Revantusk Village"] = "Village des Vengebroches",
		["River's Heart"] = "Le C\197\147ur du fleuve",
		["Ruined City Post 01"] = "Halte 1 de la ville en ruine",
		["Rut'theran Village"] = "Rut'theran",
		["Sanctum of the Stars"] = "Sanctum des \195\169toiles",
		["Sentinel Hill"] = "Colline des sentinelles",
		["Shadowmoon Village"] = "Village d'Ombrelune",
		["Shadowprey Village"] = "Proie-de-l'Ombre",
		["Shatter Point"] = "Halte du Fracas",
		["Shattered Sun Staging Area"] = "Zone de rassemblement du Soleil bris\195\169",
		["Silvermoon City"] = "Lune-d'argent",
		["Southshore"] = "Austrivage",
		["Spinebreaker Ridge"] = "Cr\195\170te Brise-\195\169chine",
		["Splintertree Post"] = "Poste de Bois-bris\195\169",
		["Star's Rest"] = "Repos des \195\169toiles",
		["Stonard"] = "Pierr\195\170che",
		["Stonebreaker Hold"] = "Fort des Brise-pierres",
		["Stonetalon Peak"] = "Pic des Serres-Rocheuses",
		["Stormwind"] = "Hurlevent",
		["Sun Rock Retreat"] = "Retraite de Roche-Soleil",
		["Sunreaver's Command"] = "Quartier g\195\169n\195\169ral de Saccage-soleil",
		["Swamprat Post"] = "Poste du Rat des marais",
		["Talonbranch Glade"] = "Clairi\195\168re de Griffebranche",
		["Talrendis Point"] = "Halte de Talrendis",
		["Tarren Mill"] = "Moulin-de-Tarren",
		["Taunka'le Village"] = "Taunka'le",
		["Temple of Telhamat"] = "Temple de Telhamat",
		["The Argent Stand"] = "Le s\195\169jour d'Argent",
		["The Argent Vanguard"] = "L'avant-garde d'Argent",
		["The Exodar"] = "L'Exodar",
		["The Sepulcher"] = "Le S\195\169pulcre",
		["The Shadow Vault"] = "Le Caveau des ombres",
		["The Stormspire"] = "La Foudrefl\195\168che",
		["Thorium Point"] = "Halte du Thorium",
		["Thunder Bluff"] = "Les Pitons du Tonnerre",
		["Thunderlord Stronghold"] = "Bastion des Sire-tonnerre",
		["Toshley's Station"] = "Poste de Toshley",
		["Transitus Shield"] = "Bouclier Transitus",
		["Transport: Menethil <-> Valgarde"] = "Transport : Menethil <-> Valgarde",
		["Undercity"] = "Fossoyeuse",
		["Valgarde Port"] = "Port-Valgarde",
		["Valiance Keep"] = "Donjon de la Bravoure",
		["Valiance Landing Camp"] = "Terrain d'atterrissage de la Bravoure",
		["Vengeance Landing"] = "Accostage de la Vengeance",
		["Venomspite"] = "Vexevenin",
		["Warsong Camp"] = "Camp chanteguerre",
		["Warsong Hold"] = "Bastion Chanteguerre",
		["Westfall Brigade"] = "Brigade de la marche de l'Ouest",
		["Westguard Keep"] = "Donjon de la Garde de l'ouest",
		["Wildhammer Stronghold"] = "Bastion Marteau-hardi",
		["Windrunner's Overlook"] = "Surplomb de Coursevent",
		["Wintergarde Keep"] = "Donjon de Garde-hiver",
		["Wyrmrest Temple"] = "Temple du Repos du ver",
		["Zoram'gar Outpost"] = "Avant-poste de Zoram'gar",
	}

elseif GetLocale() == "esES" or GetLocale() == "esMX" then	-- Spanish

	BINDING_NAME_NxMAPTOGORIGINAL		= "Toggle Original Map"
	BINDING_NAME_NxMAPTOGNORMMAX		= "Toggle Normal or Max Map"
	BINDING_NAME_NxMAPTOGNONEMAX		= "Toggle None or Max Map"
	BINDING_NAME_NxMAPTOGNONENORM		= "Toggle None or Normal Map"
	BINDING_NAME_NxMAPSCALERESTORE	= "Restore Saved Map Scale"
	BINDING_NAME_NxMAPTOGMINIFULL		= "Toggle Full Size Minimap"
	BINDING_NAME_NxMAPTOGHERB			= "Toggle Herbs on map"
	BINDING_NAME_NxMAPTOGMINE			= "Toggle Mining on map"
	BINDING_NAME_NxTOGGLEFAV			= "Toggle Favorites"
	BINDING_NAME_NxTOGGLEGUIDE			= "Toggle Guide"
	BINDING_NAME_NxTOGGLEWAREHOUSE	= "Toggle Warehouse"
	BINDING_NAME_NxTOGGLEWATCHMINI	= "Toggle Watch List Minimize"
	BINDING_NAME_NxWATCHUSEITEM		= "Use Top Quest Watch Item"
	BINDING_NAME_NxMAPSKIPTARGET		= "Skip Current Target"

	NXLOADING			= "loading"
	NXLOAD_DONE			= "load done"

	NXlGas				= "Gas"
	NXlEXTRACTGAS		= "Extraer gas"
	NXlFISHING			= "Pesca"
	NXlHERBGATHERING	= "Recolectar hierbas"
	NXlINCONFLICT		= "En conflicto"
	NXlLEVELSPC			= "Nivel "
	NXlMINING			= "Miner\195\173a"
	NXlOpening			= "Apertura"
	NXlOpeningNoText	= "Apertura - Sin texto"
	NXlGLOWCAP			= "Fluochampi\195\177\195\179n"
	NXlEverfrost		= "Esquirla de siemprescarcha"

	NxlRiding			= "Equitaci\195\179n"

	NXlDurPattern = "^Durabilidad (%d+) / (%d+)"

	NXlClassLocToCap = {		-- Convert localized class name to generic caps
		["Caballero de la muerte"] = "DEATHKNIGHT",
		["Druida"] = "DRUID",
		["Cazador"] = "HUNTER",
		["Cazadora"] = "HUNTER",
		["Mago"] = "MAGE",
		["Maga"] = "MAGE",
		["Palad\195\173n"] = "PALADIN",
		["Sacerdote"] = "PRIEST",
		["Sacerdotisa"] = "PRIEST",
		["P\195\173caro"] = "ROGUE",
		["P\195\173cara"] = "ROGUE",
		["Cham\195\161n"] = "SHAMAN",
		["Brujo"] = "WARLOCK",
		["Bruja"] = "WARLOCK",
		["Guerrero"] = "WARRIOR",
		["Guerrera"] = "WARRIOR",
	}

	NXlBGMessages = {		-- Battleground messages. Menu text, message text
		"Incoming", "Inc",
		"Clear", "Clear",
		"Help", "Help",
		"Attack", "Attack",
		"Guard", "Guard",
		"Well Defended", "Well Defended",
		"Losing", "Losing",
	}

	NXlBGStatus			= "Report Status"

	NXlItemTypes = {
		ARMOR,
		"Consumible",
		"Contenedor",
		"Gema",
		"Glifo",
		"Llave",
		"Miscel\195\161nea",
		"Proyectil",
		"Misi\195\179n",
		"Carcaj",
		"Componente",
		"Receta",
		"Objeto comerciable",
		"Arma",
	}

	NXlMapNames = { -- ES
		["Ahn'kahet: The Old Kingdom"] = "Ahn'kahet: El Antiguo Reino",
		["Alterac Mountains"] = "Monta\195\177as de Alterac",
		["Alterac Valley"] = "Valle de Alterac",
		["Arathi Basin"] = "Cuenca de Arathi",
		["Arathi Highlands"] = "Tierras Altas de Arathi",
		["Ashenvale"] = "Vallefresno",
		["Auchenai Crypts"] = "Criptas Auchenai",
		["Azshara Crater"] = "Cr\195\161ter de Azshara",
		["Azuremyst Isle"] = "Isla Bruma Azur",
		["Badlands"] = "Tierras Inh\195\179spitas",
		["Black Temple"] = "Templo Oscuro",
		["Blackfathom Deeps"] = "Cavernas de Brazanegra",
		["Blackrock Depths"] = "Profundidades de Roca Negra",
		["Blackrock Mountain"] = "Monta\195\177a Roca Negra",
		["Blackrock Spire"] = "Cumbre de Roca Negra",
		["Blackwing Lair"] = "Guarida Alanegra",
		["Blade's Edge Arena"] = "Arena Filospada",
		["Blade's Edge Mountains"] = "Monta\195\177as Filospada",
		["Blasted Lands"] = "Las Tierras Devastadas",
		["Bloodmyst Isle"] = "Isla Bruma de Sangre",
		["Borean Tundra"] = "Tundra Boreal",
		["Burning Steppes"] = "Las Estepas Ardientes",
		["Caverns of Time"] = "Cavernas del Tiempo",
		["Champions' Hall"] = "Sala de los Campeones",
		["City"] = "Ciudad",
		["Crystalsong Forest"] = "Bosque Canto de Cristal",
		["Dalaran Arena"] = "Arena de Dalaran",
		["Darkshore"] = "Costa Oscura",
		["Deadwind Pass"] = "Paso de la Muerte",
		["Deeprun Tram"] = "Tranv\195\173a Subterr\195\161neo",
		["Designer Island"] = "Isla del Dise\195\177ador",
		["Development Land"] = "Tierra de Desarrollo",
		["Dire Maul"] = "La Masacre",
		["Dragonblight"] = "Cementerio de Dragones",
		["Drak'Tharon Keep"] = "Fortaleza de Drak'Tharon",
		["Duskwood"] = "Bosque del Ocaso",
		["Dustwallow Marsh"] = "Marjal Revolcafango",
		["Eastern Plaguelands"] = "Tierras de la Peste del Este",
		["Elwynn Forest"] = "Bosque de Elwynn",
		["Emerald Forest"] = "Bosque Esmeralda",
		["Eversong Woods"] = "Bosque Canci\195\179n Eterna",
		["Eye of the Storm"] = "Ojo de la Tormenta",
		["Felwood"] = "Frondavil",
		["Force Interior"] = "Fuerza Interior",
		["Gates of Ahn'Qiraj"] = "Puerta de Ahn'Qiraj",
		["Ghostlands"] = "Tierras Fantasma",
		["Gillijim's Isle"] = "Isla de Gillijim",
		["GM Island"] = "Isla de los MJ",
		["Grizzly Hills"] = "Colinas Pardas",
		["Gruul's Lair"] = "Guarida de Gruul",
		["Hall of Legends"] = "Sala de las Leyendas",
		["Halls of Lightning"] = "C\195\161maras de Rel\195\161mpagos",
		["Halls of Stone"] = "C\195\161maras de Piedra",
		["Hellfire Citadel"] = "Ciudadela del Fuego Infernal",
		["Hellfire Peninsula"] = "Pen\195\173nsula del Fuego Infernal",
		["Hellfire Ramparts"] = "Murallas del Fuego Infernal",
		["Hillsbrad Foothills"] = "Laderas de Trabalomas",
		["Howling Fjord"] = "Fiordo Aquilonal",
		["Hrothgar's Landing"] = "Desembarco de Hrothgar",
		["Hyjal Past"] = "El Pasado Hyjal",
		["Hyjal Summit"] = "La Cima Hyjal",
		["Icecrown"] = "Corona de Hielo",
		["Ironforge"] = "Forjaz",
		["Island of Doctor Lapidis"] = "Isla del Doctor Lapidis",
		["Isle of Quel'Danas"] = "Isla de Quel'Danas",
		["Lordamere Lake"] = "Lago Lordamere",
		["Magisters' Terrace"] = "Bancal del Magister",
		["Magtheridon's Lair"] = "Guarida de Magtheridon",
		["Mana-Tombs"] = "Tumbas de Man\195\161",
		["Molten Core"] = "N\195\186cleo de Magma",
		["Moonglade"] = "Claro de la Luna",
		["Nagrand Arena"] = "Arena de Nagrand",
		["Netherstorm"] = "Tormenta Abisal",
		["Old Hillsbrad Foothills"] = "Antiguas Laderas de Trabalomas",
		["Onyxia's Lair"] = "Guarida de Onyxia",
		["Outland"] = "Terrallende",
		["Plaguelands: The Scarlet Enclave"] = "Tierras de la Peste del Este: El Enclave Escarlata",
		["Programmer Isle"] = "Isla del Programador",
		["Ragefire Chasm"] = "Sima \195\141gnea",
		["Razorfen Downs"] = "Zah\195\186rda Rajacieno",
		["Razorfen Kraul"] = "Horado Rajacieno",
		["Redridge Mountains"] = "Monta\195\177as Crestagrana",
		["Ruins of Ahn'Qiraj"] = "Ruinas de Ahn'Qiraj",
		["Ruins of Lordaeron"] = "Ruinas de Lordaeron",
		["Scarlet Monastery"] = "Monasterio Escarlata",
		["Searing Gorge"] = "La Garganta de Fuego",
		["Serpentshrine Cavern"] = "Caverna Santuario Serpiente",
		["Sethekk Halls"] = "Salas Sethekk",
		["Shadow Labyrinth"] = "Laberinto de las Sombras",
		["Shadowfang Keep"] = "Castillo de Colmillo Oscuro",
		["Shadowmoon Valley"] = "Valle Sombraluna",
		["Shattrath City"] = "Ciudad de Shattrath",
		["Sholazar Basin"] = "Cuenca de Sholazar",
		["Silvermoon City"] = "Ciudad de Lunargenta",
		["Silverpine Forest"] = "Bosque de Arg\195\169nteos",
		["Southfury River"] = "R\195\173o Furia del Sur",
		["Stonetalon Mountains"] = "Sierra Espol\195\179n",
		["Stormwind City"] = "Ciudad de Ventormenta",
		["Strand of the Ancients"] = "Playa de los Ancestros",
		["Stranglethorn Vale"] = "Vega de Tuercespina",
		["Sunken Temple"] = "Templo Sumergido",
		["Sunwell Plateau"] = "Meseta de La Fuente del Sol",
		["Swamp of Sorrows"] = "Pantano de las Penas",
		["Tempest Keep"] = "El Castillo de la Tempestad",
		["Terokkar Forest"] = "Bosque de Terokkar",
		["Testing"] = "Testeo",
		["Thandol Span"] = "Puente Thandol",
		["The Arcatraz"] = "El Arcatraz",
		["The Barrens"] = "Los Bald\195\173os",
		["The Black Morass"] = "La Ci\195\169naga Negra",
		["The Blood Furnace"] = "El Horno de Sangre",
		["The Botanica"] = "El Invern\195\161culo",
		["The Culling of Stratholme"] = "La Matanza de Stratholme",
		["The Deadmines"] = "Las Minas de la Muerte",
		["The Exodar"] = "El Exodar",
		["The Eye of Eternity"] = "El Ojo de la Eternidad",
		["The Forbidding Sea"] = "Mar Adusto",
		["The Frozen Sea"] = "El Mar G\195\169lido",
		["The Great Sea"] = "Mare Magnum",
		["The Hinterlands"] = "Tierras del Interior",
		["The Mechanar"] = "El Mechanar",
		["The Nexus"] = "El Nexo",
		["The North Sea"] = "El Mar del Norte",
		["The Obsidian Sanctum"] = "El Sagrario Obsidiana",
		["The Oculus"] = "El Oculus",
		["The Ring of Valor"] = "El C\195\173rculo del Valor",
		["The Shattered Halls"] = "Las Salas Arrasadas",
		["The Slave Pens"] = "Recinto de los Esclavos",
		["The Steamvault"] = "La C\195\161mara de Vapor",
		["The Stockade"] = "Las Mazmorras",
		["The Storm Peaks"] = "Las Cumbres Tormentosas",
		["The Temple of Atal'Hakkar"] = "El Templo de Atal'Hakkar",
		["The Underbog"] = "La Soti\195\169naga",
		["The Veiled Sea"] = "Mar de la Bruma",
		["The Verdant Fields"] = "Los Verdegales",
		["The Violet Hold"] = "El Basti\195\179n Violeta",
		["Thoradin's Wall"] = "Muralla de Thoradin",
		["Thousand Needles"] = "Las Mil Agujas",
		["Thunder Bluff"] = "Cima del Trueno",
		["Tirisfal Glades"] = "Claros de Tirisfal",
		["Twisting Nether"] = "El Vac\195\173o Abisal",
		["Undercity"] = "Entra\195\177as",
		["Un'Goro Crater"] = "Cr\195\161ter de Un'Goro",
		["Unused Ironcladcove"] = "Unused Cala del Acorazado",
		["Utgarde Keep"] = "Fortaleza de Utgarde",
		["Utgarde Pinnacle"] = "Pin\195\161culo de Utgarde",
		["Vault of Archavon"] = "La C\195\161mara de Archavon",
		["Vordrassil's Tears"] = "L\195\161grimas de Vordrassil",
		["Wailing Caverns"] = "Cuevas de los Lamentos",
		["Warsong Gulch"] = "Garganta Grito de Guerra",
		["Western Plaguelands"] = "Tierras de la Peste del Oeste",
		["Westfall"] = "P\195\161ramos de Poniente",
		["Wetlands"] = "Los Humedales",
		["Wintergrasp"] = "Conquista del Invierno",
		["Winterspring"] = "Cuna del Invierno",
		["Zangarmarsh"] = "Marisma de Zangar",
		["Isle of Conquest"] = "Isla de la Conquista",
		["Trial of the Champion"] = "Prueba del Cruzado",
		["Trial of the Crusader"] = "Prueba del Campe\195\179n",
	}
	NXlMapSubNames = {	-- Translate!
		["Dalaran"] = {
			["Cantrips & Crows"] = 2,
			["Circle of Wills"] = 2,
			["The Black Market"] = 2,
			["The Underbelly"] = 2,
		}
	}
	NXlTaxiNames = { -- ES
		["Acherus: The Ebon Hold"] = "Acherus: El Basti\195\179n de \195\137bano",
		["Aerie Peak"] = "Pico Nidal",
		["Agmar's Hammer"] = "Martillo de Agmar",
		["Allerian Stronghold"] = "Basti\195\179n Allerian",
		["Altar of Sha'tar"] = "Altar de Sha'tar",
		["Amber Ledge"] = "El Saliente \195\129mbar",
		["Amberpine Lodge"] = "Refugio Pino \195\129mbar",
		["Apothecary Camp"] = "Campamento de los Boticarios",
		["Area 52"] = "\195\129rea 52",
		["Argent Stand"] = "El Conf\195\173n Argento",
		["Beryl Point"] = "Alto de Beryl",
		["Blood Watch"] = "Avanzada de Sangre",
		["Bloodvenom Post"] = "Puesto del Veneno",
		["Booty Bay"] = "Bah\195\173a del Bot\195\173n",
		["Borean Tundra"] = "Tundra Boreal",
		["Bor'gorok Outpost"] = "Avanzada Bor'gorok",
		["Bouldercrag's Refuge"] = "Refugio de Pedrusc\195\179n",
		["Brackenwall Village"] = "Poblado Murohelecho",
		["Camp Mojache"] = "Campamento Mojache",
		["Camp Onequah"] = "Campamento Oneqwah",
		["Camp Oneqwah"] = "Campamento Oneqwah",
		["Camp Taurajo"] = "Campamento Taurajo",
		["Camp Tunka'lo"] = "Campamento Tunka'lo",
		["Camp Winterhoof"] = "Campamento Pezu\195\177a Invernal",
		["Cenarion Hold"] = "Fuerte Cenarion",
		["Chillwind Camp"] = "Campamento del Orvallo",
		["Coldarra"] = "Gelidar",
		["Coldarra Ledge"] = "Saliente de Gelidar",
		["Conquest Hold"] = "Basti\195\179n de la Conquista",
		["Cosmowrench"] = "Cosmotir\195\179n",
		["Crossroads"] = "El Cruce",
		["Crown Guard Tower"] = "Torre de la Corona",
		["Crusaders' Pinnacle"] = "Pin\195\161culo de los Cruzados",
		["Darkshire"] = "Villa Oscura",
		["Death's Rise"] = "Ascenso de la Muerte",
		["Eastern Plaguelands"] = "Tierras de la Peste del Este",
		["Eastwall Tower"] = "Torre de la Muralla del Este",
		["Ebon Watch"] = "Puesto de Vigilancia de \195\137bano",
		["Emerald Sanctuary"] = "Santuario Esmeralda",
		["Evergrove"] = "Soto Eterno",
		["Everlook"] = "Vista Eterna",
		["Falcon Watch"] = "Avanzada del Halc\195\179n",
		["Feathermoon"] = "Plumaluna",
		["Filming"] = "Grabando",
		["Fishing Village"] = "Aldea Pesquera",
		["Fizzcrank Airstrip"] = "Pista de Aterrizaje de Palanqueta",
		["Flame Crest"] = "Pe\195\177asco Llamarada",
		["Fordragon Hold"] = "Basti\195\179n de Fordrag\195\179n",
		["Forest Song"] = "Canci\195\179n del Bosque",
		["Fort Wildervar"] = "Fuerte Vildervar",
		["Freewind Post"] = "Poblado Viento Libre",
		["Frosthold"] = "Fuerte Escarcha",
		["Frostwolf Keep"] = "Basti\195\179n Lobo G\195\169lido",
		["Generic"] = "Gen\195\169rico",
		["Grizzly Hills"] = "\195\129rea 52",
		["Grom'arsh Crash-Site"] = "Lugar del accidente de Grom'arsh",
		["Hammerfall"] = "Sentencia",
		["Hellfire Peninsula"] = "Pen\195\173nsula del Fuego Infernal",
		["Honor Hold"] = "Basti\195\179n del Honor",
		["Ironforge"] = "Forjaz",
		["Kamagua"] = "Komawa",
		["Kor'koron Vanguard"] = "Cementerio de Dragones",
		["Lakeshire"] = "Villa del Lago",
		["Light's Breach"] = "Brecha de la Luz",
		["Light's Hope Chapel"] = "Capilla de la Esperanza de la Luz",
		["Marshal's Refuge"] = "Refugio de Marshal",
		["Menethil Harbor"] = "Puerto de Menethil",
		["Mok'Nathal Village"] = "Aldea Mok'Nathal",
		["Moonglade"] = "Claro de la Luna",
		["Morgan's Vigil"] = "Vigilia de Morgan",
		["Mudsprocket"] = "Pi\195\177\195\179n de Barro",
		["Nesingwary Base Camp"] = "Campamento Base de Nesingwary",
		["Nethergarde Keep"] = "Castillo de Nethergarde",
		["New Agamand"] = "Nuevo Agamand",
		["Nighthaven"] = "Amparo de la Noche",
		["Nijel's Point"] = "Punta de Nijel",
		["Northpass Tower"] = "Torre del Paso Norte",
		["Northshire Abbey"] = "Abad\195\173a de Villanorte",
		["Orebor Harborage"] = "Puerto Orebor",
		["Plaguewood Tower"] = "Torre del Bosque de la Peste",
		["Programmer Isle"] = "Isla del programador",
		["Ratchet"] = "Trinquete",
		["Rebel Camp"] = "Asentamiento Rebelde",
		["Refuge Pointe"] = "Refugio de la Zaga",
		["Revantusk Village"] = "Poblado Sa\195\177adiente",
		["River's Heart"] = "Coraz\195\179n de R\195\173o",
		["Ruined City Post 01"] = "Puesto 01 de la Ciudad en Ruinas",
		["Rut'theran Village"] = "Aldea Rut'theran",
		["Sanctum of the Stars"] = "Sagrario de las Estrellas",
		["Sentinel Hill"] = "Colina del Centinela",
		["Shadowmoon Village"] = "Aldea Sombraluna",
		["Shadowprey Village"] = "Aldea Cazasombras",
		["Shatter Point"] = "Puesto Devastaci\195\179n",
		["Shattered Sun Staging Area"] = "Zona de escala de Sol Devastado",
		["Silvermoon City"] = "Ciudad de Lunargenta",
		["Southshore"] = "Costasur",
		["Spinebreaker Ridge"] = "Cresta Rompeloma",
		["Splintertree Post"] = "Puesto del Hachazo",
		["Star's Rest"] = "Reposo Estelar",
		["Stonard"] = "Rocal",
		["Stonebreaker Hold"] = "Basti\195\179n Rompepedras",
		["Stonetalon Peak"] = "Cima del Espol\195\179n",
		["Stormwind"] = "Ventormenta",
		["Sun Rock Retreat"] = "Refugio Roca del Sol",
		["Sunreaver's Command"] = "Dominio de los Atracasol",
		["Swamprat Post"] = "Avanzada Rata del Pantano",
		["Talonbranch Glade"] = "Claro Ramaespol\195\179n",
		["Talrendis Point"] = "Punta Talrendis",
		["Tarren Mill"] = "Molino Tarren",
		["Taunka'le Village"] = "Poblado Taunka'le",
		["Temple of Telhamat"] = "Templo de Telhamat",
		["The Argent Stand"] = "El Conf\195\173n Argento",
		["The Argent Vanguard"] = "La Vanguardia Argenta",
		["The Exodar"] = "El Exodar",
		["The Sepulcher"] = "El Sepulcro",
		["The Shadow Vault"] = "La C\195\161mara de las Sombras",
		["The Stormspire"] = "La Flecha de la Tormenta",
		["Thorium Point"] = "Puesto del Torio",
		["Thunder Bluff"] = "Cima del Trueno",
		["Thunderlord Stronghold"] = "Basti\195\179n Se\195\177or del Trueno",
		["Toshley's Station"] = "Estaci\195\179n de Toshley",
		["Transitus Shield"] = "Escudo de Tr\195\161nsito",
		["Transport"] = "Transporte",
		["Transport: Menethil <-> Valgarde"] = "Transporte: Menethil <-> Valgarde",
		["Undercity"] = "Entra\195\177as",
		["Valgarde Port"] = "Puerto de Valgarde",
		["Valiance Keep"] = "Fortaleza Denuedo",
		["Valiance Landing Camp"] = "Campamento de Aterrizaje de Denuedo",
		["Vengeance Landing"] = "Campo Venganza",
		["Venomspite"] = "Rencor Venenoso",
		["Warsong Camp"] = "Campamento Grito de Guerra",
		["Warsong Hold"] = "Basti\195\179n Grito de Guerra",
		["Westfall Brigade"] = "Brigada de P\195\161ramos de Poniente",
		["Westguard Keep"] = "Fortaleza de la Guardia Oeste",
		["Wildhammer Stronghold"] = "Basti\195\179n Martillo Salvaje",
		["Windrunner's Overlook"] = "Mirador Brisaveloz",
		["Wintergarde Keep"] = "Fortaleza de Hibergarde",
		["Wyrmrest Temple"] = "Templo del Reposo del Drag\195\179n",
		["Zoram'gar Outpost"] = "Avanzada de Zoram'gar",
	}

else	-- English

	BINDING_NAME_NxMAPTOGORIGINAL		= "Toggle Original Map"
	BINDING_NAME_NxMAPTOGNORMMAX		= "Toggle Normal or Max Map"
	BINDING_NAME_NxMAPTOGNONEMAX		= "Toggle None or Max Map"
	BINDING_NAME_NxMAPTOGNONENORM		= "Toggle None or Normal Map"
	BINDING_NAME_NxMAPSCALERESTORE	= "Restore Saved Map Scale"
	BINDING_NAME_NxMAPTOGMINIFULL		= "Toggle Full Size Minimap"
	BINDING_NAME_NxMAPTOGHERB			= "Toggle Herbs on map"
	BINDING_NAME_NxMAPTOGMINE			= "Toggle Mining on map"
	BINDING_NAME_NxTOGGLEFAV			= "Toggle Favorites"
	BINDING_NAME_NxTOGGLEGUIDE			= "Toggle Guide"
	BINDING_NAME_NxTOGGLEWAREHOUSE	= "Toggle Warehouse"
	BINDING_NAME_NxTOGGLEWATCHMINI	= "Toggle Watch List Minimize"
	BINDING_NAME_NxWATCHUSEITEM		= "Use Top Quest Watch Item"
	BINDING_NAME_NxMAPSKIPTARGET		= "Skip Current Target"

	NXLOADING			= "loading"
	NXLOAD_DONE			= "load done"

	NXlGas				= "Gas"
	NXlEXTRACTGAS		= "Extract Gas"
	NXlFISHING			= "Fishing"
	NXlHERBGATHERING	= "Herb Gathering"
	NXlINCONFLICT		= "In Conflict"
	NXlLEVELSPC			= "Level "
	NXlMINING			= "Mining"
	NXlOpening			= "Opening"
	NXlOpeningNoText	= "Opening - No Text"
	NXlGLOWCAP			= "Glowcap"
	NXlEverfrost		= "Everfrost Chip"

	NXlRiding			= "Riding"

	NXlDurPattern = "^Durability (%d+) / (%d+)"

	NXlClassLocToCap = {		-- Convert localized class name to generic caps
		["Death Knight"] = "DEATHKNIGHT",
		["Druid"] = "DRUID",
		["Hunter"] = "HUNTER",
		["Mage"] = "MAGE",
		["Paladin"] = "PALADIN",
		["Priest"] = "PRIEST",
		["Rogue"] = "ROGUE",
		["Shaman"] = "SHAMAN",
		["Warlock"] = "WARLOCK",
		["Warrior"] = "WARRIOR",
	}

	NXlBGMessages = {		-- Battleground messages. Menu text, message text
		"Incoming", "Inc",
		"Clear", "Clear",
		"Help", "Help",
		"Attack", "Attack",
		"Guard", "Guard",
		"Well Defended", "Well Defended",
		"Losing", "Losing",
	}

	NXlBGStatus			= "Report Status"

	NXlItemTypes = {
		ARMOR,
		"Consumable",
		"Container",
		"Gem",
		"Glyph",
		"Key",
		"Miscellaneous",
		"Projectile",
		"Quest",
		"Quiver",
		"Reagent",
		"Recipe",
		"Trade Goods",
		"Weapon",
	}

	NXlMapWGOverlayName = "wintergrasp"

	NXlMapNames = {	-- Defaults
	}
	NXlMapSubNames = {
		["Dalaran"] = {
			["Cantrips & Crows"] = 2,
			["Circle of Wills"] = 2,
			["The Black Market"] = 2,
			["The Underbelly"] = 2,
		}
	}
	NXlTaxiNames = {
	}
end

--EOF










