--[[

	Atlas, a World of Warcraft instance map browser
	Copyright 2005-2010 Dan Gilbert <dan.b.gilbert@gmail.com>

	This file is part of Atlas.

	Atlas is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	Atlas is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Atlas; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

--]]

-- Atlas Data
-- Compiled by Dan Gilbert
-- loglow@gmail.com
-- Many thanks to all contributors!

local BabbleSubZone = Atlas_GetLocaleLibBabble("LibBabble-SubZone-3.0");
local BabbleZone = Atlas_GetLocaleLibBabble("LibBabble-Zone-3.0");

local BLUE = "|cff6666ff";
local GREY = "|cff999999";
local GREN = "|cff66cc33";
local _RED = "|cffcc6666";
local ORNG = "|cffcc9933";
local PURP = "|cff9900ff";
local INDENT = "      ";

local ZONE = 1;
local NPC = 2;
local ITEM = 3;
local OBJECT = 4;
local FACTION = 5;
local QUEST = 6;

AtlasMaps = {

--************************************************
-- Instance Entrance Maps
--************************************************

	AuchindounEnt = {
		ZoneName = { BabbleZone["Auchindoun"].." ("..AtlasLocale["Entrance"]..")" };
		Location = { BabbleZone["Terokkar Forest"], 3519 };
		LevelRange = "63-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Auch"];
		{ BLUE.."A) "..BabbleZone["Auchenai Crypts"], ZONE, 3790 };
		{ BLUE.."B) "..BabbleZone["Mana-Tombs"], ZONE, 3792 };
		{ BLUE.."C) "..BabbleZone["Sethekk Halls"], ZONE, 3791 };
		{ BLUE.."D) "..BabbleZone["Shadow Labyrinth"], ZONE, 3789 };
		{ BLUE.."E) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Ha'Lei"], NPC, 19697 };
		{ GREY..INDENT..AtlasLocale["Greatfather Aldrimus"], NPC, 19698 };
		{ GREY..INDENT..AtlasLocale["Clarissa"], NPC, 19693 };
		{ GREY..INDENT..AtlasLocale["Ramdor the Mad"], NPC, 19417 };
		{ GREY..INDENT..AtlasLocale["Horvon the Armorer <Armorsmith>"], NPC, 19879 };
		{ GREY.."2) "..AtlasLocale["Nexus-Prince Haramad"], NPC, 19674 };
		{ GREY..INDENT..AtlasLocale["Artificer Morphalius"], NPC, 19670 };
		{ GREY..INDENT..AtlasLocale["Mamdy the \"Ologist\""], NPC, 19669 };
		{ GREY..INDENT..AtlasLocale["\"Slim\" <Shady Dealer>"], NPC, 19679 };
		{ GREY..INDENT..AtlasLocale["\"Captain\" Kaftiz"], NPC, 19676 };
		{ GREY.."3) "..AtlasLocale["Isfar"], NPC, 18933 };
		{ GREY.."4) "..AtlasLocale["Field Commander Mahfuun"], NPC, 19542 };
		{ GREY..INDENT..AtlasLocale["Spy Grik'tha"], NPC, 19496 };
		{ GREY..INDENT..AtlasLocale["Provisioner Tsaalt"], NPC, 19718 };
		{ GREY..INDENT..AtlasLocale["Dealer Tariq <Shady Dealer>"], NPC, 20986 };
		{ GREY.."5) "..AtlasLocale["Meeting Stone"] };
	};
	BlackfathomDeepsEnt = {
		ZoneName = { BabbleZone["Blackfathom Deeps"].." ("..AtlasLocale["Entrance"]..")", 719 };
		Location = { BabbleZone["Ashenvale"], 331 };
		LevelRange = "20-28";
		MinLevel = "19";
		PlayerLimit = "10";
		Acronym = AtlasLocale["BFD"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Blackfathom Deeps"], ZONE, 719 };
	};
	BlackrockSpireEnt = {
		ZoneName = { BabbleZone["Blackrock Mountain"].." ("..AtlasLocale["Entrance"]..")", 25 };
		Location = { BabbleZone["Searing Gorge"].." / "..BabbleZone["Burning Steppes"], 51, 46 };
		LevelRange = "54-60";
		MinLevel = "45";
		PlayerLimit = "5/10/40";
		Acronym = AtlasLocale["BRM"];
		{ BLUE.."A) "..BabbleZone["Searing Gorge"], ZONE, 51 };
		{ BLUE.."B) "..BabbleZone["Burning Steppes"], ZONE, 46 };
		{ BLUE.."C) "..BabbleZone["Blackrock Depths"].." ("..AtlasLocale["BRD"]..")", ZONE, 1584 };
		{ BLUE..INDENT..BabbleZone["Molten Core"].." ("..AtlasLocale["MC"]..")", ZONE, 2717 };
		{ BLUE.."D) "..BabbleZone["Blackrock Spire"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["LBRS"]..")", ZONE, 1583 };
		{ BLUE..INDENT..BabbleZone["Blackrock Spire"].." ("..AtlasLocale["Upper"]..", "..AtlasLocale["UBRS"]..")", ZONE, 1583 };
		{ BLUE..INDENT..BabbleZone["Blackwing Lair"].." ("..AtlasLocale["BWL"]..")", ZONE, 2677 };
		{ BLUE..INDENT..AtlasLocale["Bodley"].." ("..AtlasLocale["Ghost"]..")", NPC, 16033 };
		{ GREY.."1) "..AtlasLocale["Overmaster Pyron"].." ("..AtlasLocale["Wanders"]..")", NPC, 9026 };
		{ GREY.."2) "..AtlasLocale["Lothos Riftwaker"], NPC, 14387 };
		{ GREY.."3) "..AtlasLocale["Franclorn Forgewright"].." ("..AtlasLocale["Ghost"]..")", NPC, 8888 };
		{ GREY.."4) "..AtlasLocale["Meeting Stone"].." ("..AtlasLocale["BRD"]..")" };
		{ GREY.."5) "..AtlasLocale["Orb of Command"], OBJECT, 179879 };
		{ GREY.."6) "..AtlasLocale["Meeting Stone"].." ("..AtlasLocale["LBRS"]..", "..AtlasLocale["UBRS"]..")" };
		{ GREY.."7) "..AtlasLocale["Scarshield Quartermaster <Scarshield Legion>"], NPC, 9046 };
	};
	CoilfangReservoirEnt = {
		ZoneName = { BabbleZone["Coilfang Reservoir"].." ("..AtlasLocale["Entrance"]..")" };
		Location = { BabbleZone["Zangarmarsh"], 3521 };
		LevelRange = "61-70";
		MinLevel = "55";
		PlayerLimit = "5/25";
		Acronym = AtlasLocale["CR"];
		{ BLUE.."A) "..BabbleZone["The Slave Pens"], ZONE, 3717 };
		{ BLUE.."B) "..BabbleZone["The Steamvault"], ZONE, 3715 };
		{ BLUE.."C) "..BabbleZone["Serpentshrine Cavern"], ZONE, 3607 };
		{ BLUE.."D) "..BabbleZone["The Underbog"], ZONE, 3716 };
		{ BLUE.."E) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Underwater"]..")" };
		{ GREY.."1) "..AtlasLocale["Watcher Jhang"], NPC, 17884 };
		{ GREY..INDENT..AtlasLocale["Meeting Stone"] };
		{ GREY.."2) "..AtlasLocale["Mortog Steamhead"], NPC, 23373 };
	};
	CoTEnt = {
		ZoneName = { BabbleZone["Caverns of Time"].." ("..AtlasLocale["Entrance"]..")" };
		Location = { BabbleZone["Tanaris"], 440 };
		LevelRange = "66-70";
		MinLevel = "66";
		PlayerLimit = "5/25";
		Acronym = AtlasLocale["CoT"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Hyjal Summit"], ZONE, 3606 };
		{ BLUE.."C) "..BabbleZone["Old Hillsbrad Foothills"], ZONE, 2367 };
		{ BLUE.."D) "..BabbleZone["The Black Morass"], ZONE, 2366 };
		{ BLUE.."E) "..BabbleZone["The Culling of Stratholme"], ZONE, 4100 };
		{ GREY.."1) "..AtlasLocale["Steward of Time <Keepers of Time>"], NPC, 20142 };
		{ GREY.."2) "..AtlasLocale["Alexston Chrome <Tavern of Time>"], NPC, 18542 };
		{ GREY.."3) "..BabbleZone["Graveyard"] };
		{ GREY.."4) "..AtlasLocale["Yarley <Armorer>"], NPC, 20082 };
		{ GREY.."5) "..AtlasLocale["Bortega <Reagents & Poison Supplies>"], NPC, 20081 };
		{ GREY..INDENT..AtlasLocale["Galgrom <Provisioner>"], NPC, 20080 };
		{ GREY..INDENT..AtlasLocale["Alurmi <Keepers of Time Quartermaster>"], NPC, 21643 };
		{ GREY.."6) "..AtlasLocale["Zaladormu"], NPC, 19934 };
		{ GREY..INDENT..AtlasLocale["Soridormi <The Scale of Sands>"].." ("..AtlasLocale["Wanders"]..")", NPC, 19935 };
		{ GREY..INDENT..AtlasLocale["Arazmodu <The Scale of Sands>"].." ("..AtlasLocale["Wanders"]..")", NPC, 19936 };
		{ GREY.."7) "..AtlasLocale["Moonwell"] };
		{ GREY.."8) "..AtlasLocale["Andormu <Keepers of Time>"].." ("..AtlasLocale["Child"]..")", NPC, 19932 };
		{ GREY..INDENT..AtlasLocale["Nozari <Keepers of Time>"].." ("..AtlasLocale["Child"]..")", NPC, 19933 };
		{ GREY.."9) "..AtlasLocale["Andormu <Keepers of Time>"].." ("..AtlasLocale["Adult"]..")", NPC, 20130 };
		{ GREY..INDENT..AtlasLocale["Nozari <Keepers of Time>"].." ("..AtlasLocale["Adult"]..")", NPC, 20131 };
	};
	DireMaulEnt = {
		ZoneName = { BabbleZone["Dire Maul"].." ("..AtlasLocale["Entrance"]..")", 2557 };
		Location = { BabbleZone["Feralas"], 357 };
		LevelRange = "55-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["DM"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Dire Maul (East)"], ZONE, 2557 };
		{ BLUE.."C) "..BabbleZone["Dire Maul (North)"], ZONE, 2557 };
		{ BLUE.."D) "..BabbleZone["Dire Maul (West)"], ZONE, 2557 };
		{ GREY.."1) "..AtlasLocale["Dire Pool"] };
		{ GREY.."2) "..AtlasLocale["Dire Maul Arena"] };
		{ GREY..INDENT..AtlasLocale["Mushgog"].." ("..AtlasLocale["Random"]..")", NPC, 11447 };
		{ GREY..INDENT..AtlasLocale["Skarr the Unbreakable"].." ("..AtlasLocale["Random"]..")", NPC, 11498 };
		{ GREY..INDENT..AtlasLocale["The Razza"].." ("..AtlasLocale["Random"]..")", NPC, 11497 };
		{ GREY..INDENT..AtlasLocale["Elder Mistwalker"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15587 };
	};
	GnomereganEnt = {
		ZoneName = { BabbleZone["Gnomeregan"].." ("..AtlasLocale["Entrance"]..")", 133 };
		Location = { BabbleZone["Dun Morogh"], 1 };
		LevelRange = "24-32";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Gnome"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Meeting Stone"] };
		{ BLUE.."B) "..BabbleZone["Gnomeregan"].." ("..AtlasLocale["Front"]..")", ZONE, 133 };
		{ BLUE.."C) "..BabbleZone["Gnomeregan"].." ("..AtlasLocale["Back"]..")", ZONE, 133 };
		{ GREY.."1) "..AtlasLocale["Elevator"] };
		{ GREY.."2) "..AtlasLocale["Transpolyporter"] };
		{ GREY..INDENT..AtlasLocale["Sprok <Away Team>"], NPC, 8320 };
		{ GREY.."3) "..AtlasLocale["Matrix Punchograph 3005-A"], OBJECT, 142345 };
		{ GREY..INDENT..AtlasLocale["Namdo Bizzfizzle <Engineering Supplies>"], NPC, 2683 };
		{ GREY.."4) "..AtlasLocale["Techbot"], NPC, 6231 };
	};
	HCEnt = {
		ZoneName = { BabbleZone["Hellfire Citadel"].." ("..AtlasLocale["Entrance"]..")", 3545 };
		Location = { BabbleZone["Hellfire Peninsula"], 3483 };
		LevelRange = "59-70";
		MinLevel = "55";
		PlayerLimit = "5/25";
		Acronym = AtlasLocale["HC"];
		{ BLUE.."A) "..BabbleZone["Hellfire Ramparts"], ZONE, 3562 };
		{ BLUE.."B) "..BabbleZone["The Shattered Halls"], ZONE, 3714 };
		{ BLUE.."C) "..BabbleZone["The Blood Furnace"], ZONE, 3713 };
		{ BLUE.."D) "..BabbleZone["Magtheridon's Lair"], ZONE, 3836 };
		{ GREY.."1) "..AtlasLocale["Meeting Stone of Magtheridon's Lair"] };
		{ GREY.."2) "..AtlasLocale["Meeting Stone of Hellfire Citadel"] };
		{ GREN.."1') "..AtlasLocale["Steps and path to the Blood Furnace"] };
		{ GREN.."2') "..AtlasLocale["Path to the Hellfire Ramparts and Shattered Halls"] };
	};
	KarazhanEnt = {
		ZoneName = { BabbleZone["Karazhan"].." ("..AtlasLocale["Entrance"]..")", 2562 };
		Location = { BabbleZone["Deadwind Pass"], 41 };
		LevelRange = "70";
		MinLevel = "68";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Kara"];
		{ BLUE.."A) "..BabbleZone["Karazhan"].." ("..AtlasLocale["Front"]..")", ZONE, 2562 };
		{ BLUE.."B) "..BabbleZone["Karazhan"].." ("..AtlasLocale["Back"]..")", ZONE, 2562 };
		{ BLUE.."C) "..AtlasLocale["Meeting Stone"] };
		{ BLUE.."D) "..BabbleZone["Graveyard"] };
		{ GREY.."1) "..AtlasLocale["Archmage Leryda"], NPC, 18253 };
		{ GREY.."2) "..AtlasLocale["Apprentice Darius"], NPC, 18255 };
		{ GREY.."3) "..AtlasLocale["Archmage Alturus"], NPC, 17613 };
		{ GREY.."4) "..AtlasLocale["Stairs to Underground Pond"] };
		{ GREY.."5) "..AtlasLocale["Stairs to Underground Well"] };
		{ GREY.."6) "..AtlasLocale["Charred Bone Fragment"], OBJECT, 181963 };
	};
	MaraudonEnt = {
		ZoneName = { BabbleZone["Maraudon"].." ("..AtlasLocale["Entrance"]..")", 2100 };
		Location = { BabbleZone["Desolace"], 405 };
		LevelRange = "42-51";
		MinLevel = "30";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Mara"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["The Nameless Prophet"], NPC, 13718 };
		{ BLUE.."B) "..BabbleZone["Maraudon"].." ("..AtlasLocale["Purple"]..")", ZONE, 2100 };
		{ BLUE.."C) "..BabbleZone["Maraudon"].." ("..AtlasLocale["Orange"]..")", ZONE, 2100 };
		{ BLUE.."D) "..BabbleZone["Maraudon"].." ("..AtlasLocale["Portal"]..")", ZONE, 2100 };
		{ GREY.."1) "..AtlasLocale["Kolk <The First Kahn>"], NPC, 13742 };
		{ GREY.."2) "..AtlasLocale["Gelk <The Second Kahn>"], NPC, 13741 };
		{ GREY.."3) "..AtlasLocale["Magra <The Third Kahn>"], NPC, 13740 };
		{ GREY.."4) "..AtlasLocale["Cavindra"], NPC, 13697 };
	};
	SMEnt = {
		ZoneName = { BabbleZone["Scarlet Monastery"].." ("..AtlasLocale["Entrance"]..")", 796 };
		Location = { BabbleZone["Tirisfal Glades"], 85 };
		LevelRange = "28-42";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["SM"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Graveyard"], ZONE, 796 };
		{ BLUE.."C) "..BabbleZone["Cathedral"], ZONE, 796 };
		{ BLUE.."D) "..BabbleZone["Armory"], ZONE, 796 };
		{ BLUE.."E) "..BabbleZone["Library"], ZONE, 796 };
	};
	TheDeadminesEnt = {
		ZoneName = { BabbleZone["The Deadmines"].." ("..AtlasLocale["Entrance"]..")", 1581 };
		Location = { BabbleZone["Westfall"], 40 };
		LevelRange = "16-22";
		MinLevel = "10";
		PlayerLimit = "10";
		Acronym = AtlasLocale["VC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["The Deadmines"], ZONE, 1581 };
		{ GREY.."1) "..AtlasLocale["Marisa du'Paige"].." ("..AtlasLocale["Varies"]..")", NPC, 599 };
		{ GREY.."2) "..AtlasLocale["Brainwashed Noble"].." ("..AtlasLocale["Rare"]..")", NPC, 596 };
		{ GREY.."3) "..AtlasLocale["Foreman Thistlenettle"], NPC, 626 };
	};
	TheSunkenTempleEnt = {
		ZoneName = { BabbleZone["Sunken Temple"].." ("..AtlasLocale["Entrance"]..")", 1417 };
		Location = { BabbleZone["Swamp of Sorrows"], 8 };
		LevelRange = "46-53";
		MinLevel = "35";
		PlayerLimit = "10";
		Acronym = AtlasLocale["ST"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Meeting Stone"] };
		{ BLUE..INDENT..AtlasLocale["Jade"].." ("..AtlasLocale["Rare"]..")", NPC, 1063 };
		{ BLUE.."B) "..BabbleZone["Sunken Temple"], ZONE, 1417 };
		{ GREY.."1) "..AtlasLocale["Kazkaz the Unholy"].." ("..AtlasLocale["Upper"]..")", NPC, 5401 };
		{ GREY.."2) "..AtlasLocale["Veyzhak the Cannibal"], NPC, 5399 };
		{ GREY.."3) "..AtlasLocale["Zekkis"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Lower"]..")", NPC, 5400 };
	};
	UldamanEnt = {
		ZoneName = { BabbleZone["Uldaman"].." ("..AtlasLocale["Entrance"]..")", 1337 };
		Location = { BabbleZone["Badlands"], 3 };
		LevelRange = "36-42";
		MinLevel = "30";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Ulda"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Uldaman"], ZONE, 1337 };
		{ GREY.."1) "..AtlasLocale["Hammertoe Grez"], NPC, 2909 };
		{ GREY.."2) "..AtlasLocale["Magregan Deepshadow"].." ("..AtlasLocale["Wanders"]..")", NPC, 2932 };
		{ GREY.."3) "..AtlasLocale["Tablet of Ryun'Eh"], ITEM, 4631 };
		{ GREY.."4) "..AtlasLocale["Krom Stoutarm's Chest"], OBJECT, 124389 };
		{ GREY.."5) "..AtlasLocale["Garrett Family Chest"], OBJECT, 124388 };
		{ GREN.."1') "..AtlasLocale["Digmaster Shovelphlange"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 7057 };
	};
	WailingCavernsEnt = {
		ZoneName = { BabbleZone["Wailing Caverns"].." ("..AtlasLocale["Entrance"]..")", 718 };
		Location = { BabbleZone["The Barrens"], 17 };
		LevelRange = "16-25";
		MinLevel = "10";
		PlayerLimit = "10";
		Acronym = AtlasLocale["WC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Wailing Caverns"], ZONE, 718 };
		{ GREY.."1) "..AtlasLocale["Mad Magglish"].." ("..AtlasLocale["Varies"]..")", NPC, 3655 };
		{ GREY.."2) "..AtlasLocale["Trigore the Lasher"].." ("..AtlasLocale["Rare"]..")", NPC, 3652 };
		{ GREY.."3) "..AtlasLocale["Boahn <Druid of the Fang>"].." ("..AtlasLocale["Rare"]..")", NPC, 3672 };
		{ "" };
		{ ORNG..AtlasLocale["Above the Entrance:"] };
		{ GREY..INDENT..AtlasLocale["Ebru <Disciple of Naralex>"], NPC, 5768 };
		{ GREY..INDENT..AtlasLocale["Nalpak <Disciple of Naralex>"], NPC, 5767 };
		{ GREY..INDENT..AtlasLocale["Kalldan Felmoon <Specialist Leatherworking Supplies>"], NPC, 5783 };
		{ GREY..INDENT..AtlasLocale["Waldor <Leatherworking Trainer>"], NPC, 5784 };
	};

--************************************************
-- Kalimdor Instances (Classic)
--************************************************

	BlackfathomDeeps = {
		ZoneName = { BabbleZone["Blackfathom Deeps"], 719 };
		Location = { BabbleZone["Ashenvale"], 331 };
		LevelRange = "20-28";
		MinLevel = "19";
		PlayerLimit = "10";
		Acronym = AtlasLocale["BFD"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Ghamoo-ra"], NPC, 4887 };
		{ GREY.."2) "..AtlasLocale["Lorgalis Manuscript"], ITEM, 5359 };
		{ GREY.."3) "..AtlasLocale["Lady Sarevess"], NPC, 4831 };
		{ GREY.."4) "..AtlasLocale["Argent Guard Thaelrid <The Argent Dawn>"], NPC, 4787 };
		{ GREY.."5) "..AtlasLocale["Gelihast"], NPC, 6243 };
		{ GREY..INDENT..AtlasLocale["Shrine of Gelihast"] };
		{ GREY.."6) "..AtlasLocale["Lorgus Jett"].." ("..AtlasLocale["Varies"]..")", NPC, 12902 };
		{ GREY.."7) "..AtlasLocale["Fathom Stone"], OBJECT, 177964 };
		{ GREY..INDENT..AtlasLocale["Baron Aquanis"], NPC, 12876 };
		{ GREY.."8) "..AtlasLocale["Twilight Lord Kelris"], NPC, 4832 };
		{ GREY.."9) "..AtlasLocale["Old Serra'kis"], NPC, 4830 };
		{ GREY.."10) "..AtlasLocale["Aku'mai"], NPC, 4829 };
		{ GREY..INDENT..AtlasLocale["Morridune"], NPC, 6729 };
		{ GREY..INDENT..AtlasLocale["Altar of the Deeps"] };
	};
	DireMaulEast = {
		ZoneName = { BabbleZone["Dire Maul (East)"], 2557 };
		Location = { BabbleZone["Feralas"], 357 };
		LevelRange = "55-58";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["DM"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["DS2"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Entrance"] };
		{ BLUE.."C) "..AtlasLocale["Entrance"] };
		{ BLUE.."D) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Pusillin"].." ("..AtlasLocale["Chase Begins"]..")", NPC, 14354 };
		{ GREY.."2) "..AtlasLocale["Pusillin"].." ("..AtlasLocale["Chase Ends"]..")", NPC, 14354 };
		{ GREY.."3) "..AtlasLocale["Zevrim Thornhoof"], NPC, 11490 };
		{ GREY..INDENT..AtlasLocale["Hydrospawn"], NPC, 13280 };
		{ GREY..INDENT..AtlasLocale["Lethtendris"], NPC, 14327 };
		{ GREY..INDENT..AtlasLocale["Pimgib"], NPC, 14349 };
		{ GREY.."4) "..AtlasLocale["Old Ironbark"], NPC, 11491 };
		{ GREY.."5) "..AtlasLocale["Alzzin the Wildshaper"], NPC, 11492 };
		{ GREY..INDENT..AtlasLocale["Isalien"].." ("..AtlasLocale["Summon"]..")", NPC, 16097 };
	};
	DireMaulNorth = {
		ZoneName = { BabbleZone["Dire Maul (North)"], 2557 };
		Location = { BabbleZone["Feralas"], 357 };
		LevelRange = "57-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["DM"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Crescent Key"], ITEM, 18249 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Library"] };
		{ GREY.."1) "..AtlasLocale["Guard Mol'dar"], NPC, 14326 };
		{ GREY.."2) "..AtlasLocale["Stomper Kreeg <The Drunk>"], NPC, 14322 };
		{ GREY.."3) "..AtlasLocale["Guard Fengus"], NPC, 14321 };
		{ GREY.."4) "..AtlasLocale["Knot Thimblejack"], NPC, 14338 };
		{ GREY..INDENT..AtlasLocale["Guard Slip'kik"], NPC, 14323 };
		{ GREY.."5) "..AtlasLocale["Captain Kromcrush"], NPC, 14325 };
		{ GREY.."6) "..AtlasLocale["King Gordok"], NPC, 11501 };
		{ GREY..INDENT..AtlasLocale["Cho'Rush the Observer"], NPC, 14324 };
	};
	DireMaulWest = {
		ZoneName = { BabbleZone["Dire Maul (West)"], 2557 };
		Location = { BabbleZone["Feralas"], 357 };
		LevelRange = "57-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["DM"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Crescent Key"], ITEM, 18249 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["J'eevee's Jar"].." ("..AtlasLocale["Lord Hel'nurath"]..")", ITEM, 18663 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Pylons"] };
		{ GREY.."1) "..AtlasLocale["Shen'dralar Ancient"], NPC, 14358 };
		{ GREY.."2) "..AtlasLocale["Tendris Warpwood"], NPC, 11489 };
		{ GREY..INDENT..AtlasLocale["Ancient Equine Spirit"], NPC, 14566 };
		{ GREY.."3) "..AtlasLocale["Illyanna Ravenoak"], NPC, 11488 };
		{ GREY..INDENT..AtlasLocale["Ferra"], NPC, 14308 };
		{ GREY.."4) "..AtlasLocale["Magister Kalendris"], NPC, 11487 };
		{ GREY.."5) "..AtlasLocale["Tsu'zee"].." ("..AtlasLocale["Rare"]..")", NPC, 11467 };
		{ GREY.."6) "..AtlasLocale["Immol'thar"], NPC, 11496 };
		{ GREY..INDENT..AtlasLocale["Lord Hel'nurath"].." ("..AtlasLocale["Summon"]..")", NPC, 14506 };
		{ GREY.."7) "..AtlasLocale["Prince Tortheldrin"], NPC, 11486 };
		{ GREN.."1') "..BabbleZone["Library"] };
		{ GREN..INDENT..AtlasLocale["Falrin Treeshaper"], NPC, 16032 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Lydros"], NPC, 14368 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Javon"], NPC, 14381 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Kildrath"], NPC, 14383 };
		{ GREN..INDENT..AtlasLocale["Lorekeeper Mykos"], NPC, 14382 };
		{ GREN..INDENT..AtlasLocale["Shen'dralar Provisioner"], NPC, 14371 };
		{ GREN..INDENT..AtlasLocale["Skeletal Remains of Kariel Winthalus"], OBJECT, 179544 };
	};
	Maraudon = {
		ZoneName = { BabbleZone["Maraudon"], 2100 };
		Location = { BabbleZone["Desolace"], 405 };
		LevelRange = "42-51";
		MinLevel = "30";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Mara"];
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Orange"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Purple"]..")" };
		{ BLUE.."C) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Portal"]..")" };
		{ GREY.."1) "..AtlasLocale["Veng <The Fifth Khan>"], NPC, 13738 };
		{ GREY.."2) "..AtlasLocale["Noxxion"], NPC, 13282 };
		{ GREY.."3) "..AtlasLocale["Razorlash"], NPC, 12258 };
		{ GREY.."4) "..AtlasLocale["Maraudos <The Fourth Khan>"], NPC, 13739 };
		{ GREY.."5) "..AtlasLocale["Lord Vyletongue"], NPC, 12236 };
		{ GREY.."6) "..AtlasLocale["Meshlok the Harvester"].." ("..AtlasLocale["Rare"]..")", NPC, 12237 };
		{ GREY.."7) "..AtlasLocale["Celebras the Cursed"], NPC, 12225 };
		{ GREY.."8) "..AtlasLocale["Landslide"], NPC, 12203 };
		{ GREY.."9) "..AtlasLocale["Tinkerer Gizlock"], NPC, 13601 };
		{ GREY.."10) "..AtlasLocale["Rotgrip"], NPC, 13596 };
		{ GREY.."11) "..AtlasLocale["Princess Theradras"], NPC, 12201 };
		{ GREY.."12) "..AtlasLocale["Elder Splitrock"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15556 };
	};
	RagefireChasm = {
		ZoneName = { BabbleZone["Ragefire Chasm"], 2437 };
		Location = { BabbleZone["Orgrimmar"], 1637 };
		LevelRange = "12-18";
		MinLevel = "8";
		PlayerLimit = "10";
		Acronym = AtlasLocale["RFC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Maur Grimtotem"], NPC, 11834 };
		{ GREY..INDENT..AtlasLocale["Oggleflint <Ragefire Chieftain>"], NPC, 11517 };
		{ GREY.."2) "..AtlasLocale["Taragaman the Hungerer"], NPC, 11520 };
		{ GREY.."3) "..AtlasLocale["Jergosh the Invoker"], NPC, 11518 };
		{ GREY..INDENT..AtlasLocale["Zelemar the Wrathful"].." ("..AtlasLocale["Summon"]..")", NPC, 17830 };
		{ GREY.."4) "..AtlasLocale["Bazzalan"], NPC, 11519 };
	};
	RazorfenDowns = {
		ZoneName = { BabbleZone["Razorfen Downs"], 722 };
		Location = { BabbleZone["The Barrens"], 17 };
		LevelRange = "33-42";
		MinLevel = "25";
		PlayerLimit = "10";
		Acronym = AtlasLocale["RFD"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Tuten'kash"], NPC, 7355 };
		{ GREY.."2) "..AtlasLocale["Henry Stern"], NPC, 8696 };
		{ GREY..INDENT..AtlasLocale["Belnistrasz"], NPC, 8516 };
		{ GREY..INDENT..AtlasLocale["Sah'rhee"], NPC, 8767 };
		{ GREY.."3) "..AtlasLocale["Mordresh Fire Eye"], NPC, 7357 };
		{ GREY.."4) "..AtlasLocale["Glutton"], NPC, 8567 };
		{ GREY.."5) "..AtlasLocale["Ragglesnout"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 7354 };
		{ GREY.."6) "..AtlasLocale["Amnennar the Coldbringer"], NPC, 7358 };
		{ GREY.."7) "..AtlasLocale["Plaguemaw the Rotting"], NPC, 7356 };
	};
	RazorfenKraul = {
		ZoneName = { BabbleZone["Razorfen Kraul"], 491 };
		Location = { BabbleZone["The Barrens"], 17 };
		LevelRange = "23-33";
		MinLevel = "17";
		PlayerLimit = "10";
		Acronym = AtlasLocale["RFK"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Roogug"], NPC, 6168 };
		{ GREY.."2) "..AtlasLocale["Aggem Thorncurse <Death's Head Prophet>"], NPC, 4424 };
		{ GREY.."3) "..AtlasLocale["Death Speaker Jargba <Death's Head Captain>"], NPC, 4428 };
		{ GREY.."4) "..AtlasLocale["Overlord Ramtusk"], NPC, 4420 };
		{ GREY..INDENT..AtlasLocale["Razorfen Spearhide"], NPC, 4438 };
		{ GREY.."5) "..AtlasLocale["Agathelos the Raging"], NPC, 4422 };
		{ GREY.."6) "..AtlasLocale["Blind Hunter"].." ("..AtlasLocale["Rare"]..")", NPC, 4425 };
		{ GREY.."7) "..AtlasLocale["Charlga Razorflank <The Crone>"], NPC, 4421 };
		{ GREY.."8) "..AtlasLocale["Willix the Importer"], NPC, 4508 };
		{ GREY..INDENT..AtlasLocale["Heralath Fallowbrook"], NPC, 4510 };
		{ GREY.."9) "..AtlasLocale["Earthcaller Halmgar"].." ("..AtlasLocale["Rare"]..")", NPC, 4842 };
	};
	TheRuinsofAhnQiraj = {
		ZoneName = { BabbleZone["Ahn'Qiraj"]..": "..BabbleZone["Ruins of Ahn'Qiraj"], 3429 };
		Location = { BabbleZone["Silithus"], 1377 };
		LevelRange = "60-70";
		MinLevel = "50";
		PlayerLimit = "20";
		Acronym = AtlasLocale["AQ20"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Cenarion Circle"], FACTION, 609 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Kurinnaxx"], NPC, 15348 };
		{ GREY..INDENT..AtlasLocale["Lieutenant General Andorov"], NPC, 15471 };
		{ GREY..INDENT..AtlasLocale["Four Kaldorei Elites"], NPC, 15473 };
		{ GREY.."2) "..AtlasLocale["General Rajaxx"], NPC, 15341 };
		{ GREY..INDENT..AtlasLocale["Captain Qeez"], NPC, 15391 };
		{ GREY..INDENT..AtlasLocale["Captain Tuubid"], NPC, 15392 };
		{ GREY..INDENT..AtlasLocale["Captain Drenn"], NPC, 15389 };
		{ GREY..INDENT..AtlasLocale["Captain Xurrem"], NPC, 15390 };
		{ GREY..INDENT..AtlasLocale["Major Yeggeth"], NPC, 15386 };
		{ GREY..INDENT..AtlasLocale["Major Pakkon"], NPC, 15388 };
		{ GREY..INDENT..AtlasLocale["Colonel Zerran"], NPC, 15385 };
		{ GREY.."3) "..AtlasLocale["Moam"].." ("..AtlasLocale["Optional"]..")", NPC, 15340 };
		{ GREY.."4) "..AtlasLocale["Buru the Gorger"].." ("..AtlasLocale["Optional"]..")", NPC, 15370 };
		{ GREY.."5) "..AtlasLocale["Ayamiss the Hunter"].." ("..AtlasLocale["Optional"]..")", NPC, 15369 };
		{ GREY.."6) "..AtlasLocale["Ossirian the Unscarred"], NPC, 15339 };
		{ GREN.."1') "..AtlasLocale["Safe Room"] };
	};
	TheTempleofAhnQiraj = {
		ZoneName = { BabbleZone["Ahn'Qiraj"]..": "..BabbleZone["Temple of Ahn'Qiraj"], 3428 };
		Location = { BabbleZone["Silithus"], 1377 };
		LevelRange = "60-70";
		MinLevel = "50";
		PlayerLimit = "40";
		Acronym = AtlasLocale["AQ40"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Brood of Nozdormu"], FACTION, 910 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["The Prophet Skeram"].." ("..AtlasLocale["Outside"]..")", NPC, 15263 };
		{ GREY.."2) "..AtlasLocale["The Bug Family"].." ("..AtlasLocale["Optional"]..")" };
		{ GREY..INDENT..AtlasLocale["Vem"], NPC, 15544 };
		{ GREY..INDENT..AtlasLocale["Lord Kri"], NPC, 15511 };
		{ GREY..INDENT..AtlasLocale["Princess Yauj"], NPC, 15543 };
		{ GREY.."3) "..AtlasLocale["Battleguard Sartura"], NPC, 15516 };
		{ GREY.."4) "..AtlasLocale["Fankriss the Unyielding"], NPC, 15510 };
		{ GREY.."5) "..AtlasLocale["Viscidus"].." ("..AtlasLocale["Optional"]..")", NPC, 15299 };
		{ GREY.."6) "..AtlasLocale["Princess Huhuran"], NPC, 15509 };
		{ GREY.."7) "..AtlasLocale["Twin Emperors"] };
		{ GREY..INDENT..AtlasLocale["Emperor Vek'lor"], NPC, 15276 };
		{ GREY..INDENT..AtlasLocale["Emperor Vek'nilash"], NPC, 15275 };
		{ GREY.."8) "..AtlasLocale["Ouro"].." ("..AtlasLocale["Optional"]..")", NPC, 15517 };
		{ GREY.."9) "..AtlasLocale["Eye of C'Thun"], NPC, 15589 };
		{ GREY..INDENT..AtlasLocale["C'Thun"], NPC, 15727 };
		{ GREN.."1') "..AtlasLocale["Andorgos <Brood of Malygos>"], NPC, 15502 };
		{ GREN..INDENT..AtlasLocale["Vethsera <Brood of Ysera>"], NPC, 15504 };
		{ GREN..INDENT..AtlasLocale["Kandrostrasz <Brood of Alexstrasza>"], NPC, 15503 };
		{ GREN.."2') "..AtlasLocale["Arygos"], NPC, 15380 };
		{ GREN..INDENT..AtlasLocale["Caelestrasz"], NPC, 15379 };
		{ GREN..INDENT..AtlasLocale["Merithra of the Dream"], NPC, 15378 };
	};
	WailingCaverns = {
		ZoneName = { BabbleZone["Wailing Caverns"], 718 };
		Location = { BabbleZone["The Barrens"], 17 };
		LevelRange = "16-25";
		MinLevel = "10";
		PlayerLimit = "10";
		Acronym = AtlasLocale["WC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Disciple of Naralex"], NPC, 3678 };
		{ GREY.."2) "..AtlasLocale["Lord Cobrahn <Fanglord>"], NPC, 3669 };
		{ GREY.."3) "..AtlasLocale["Lady Anacondra <Fanglord>"].." ("..AtlasLocale["Varies"]..")", NPC, 3671 };
		{ GREY.."4) "..AtlasLocale["Kresh"].." ("..AtlasLocale["Varies"]..")", NPC, 3653 };
		{ GREY.."5) "..AtlasLocale["Lord Pythas <Fanglord>"], NPC, 3670 };
		{ GREY.."6) "..AtlasLocale["Skum"], NPC, 3674 };
		{ GREY.."7) "..AtlasLocale["Lord Serpentis <Fanglord>"].." ("..AtlasLocale["Upper"]..")", NPC, 3673 };
		{ GREY.."8) "..AtlasLocale["Verdan the Everliving"].." ("..AtlasLocale["Upper"]..")", NPC, 5775 };
		{ GREY.."9) "..AtlasLocale["Mutanus the Devourer"], NPC, 3654 };
		{ GREY..INDENT..AtlasLocale["Naralex"], NPC, 3679 };
		{ GREY.."10) "..AtlasLocale["Deviate Faerie Dragon"].." ("..AtlasLocale["Rare"]..")", NPC, 5912 };
	};
	ZulFarrak = {
		ZoneName = { BabbleZone["Zul'Farrak"], 978 };
		Location = { BabbleZone["Tanaris"], 440 };
		LevelRange = "42-48";
		MinLevel = "35";
		PlayerLimit = "10";
		Acronym = AtlasLocale["ZF"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Antu'sul <Overseer of Sul>"], NPC, 8127 };
		{ GREY.."2) "..AtlasLocale["Theka the Martyr"], NPC, 7272 };
		{ GREY.."3) "..AtlasLocale["Witch Doctor Zum'rah"], NPC, 7271 };
		{ GREY..INDENT..AtlasLocale["Zul'Farrak Dead Hero"], NPC, 7276 };
		{ GREY.."4) "..AtlasLocale["Nekrum Gutchewer"], NPC, 7796 };
		{ GREY..INDENT..AtlasLocale["Shadowpriest Sezz'ziz"], NPC, 7275 };
		{ GREY..INDENT..AtlasLocale["Dustwraith"].." ("..AtlasLocale["Rare"]..")", NPC, 10081 };
		{ GREY.."5) "..AtlasLocale["Sergeant Bly"], NPC, 7604 };
		{ GREY..INDENT..AtlasLocale["Weegli Blastfuse"], NPC, 7607 };
		{ GREY..INDENT..AtlasLocale["Murta Grimgut"], NPC, 7608 };
		{ GREY..INDENT..AtlasLocale["Raven"], NPC, 7605 };
		{ GREY..INDENT..AtlasLocale["Oro Eyegouge"], NPC, 7606 };
		{ GREY..INDENT..AtlasLocale["Sandfury Executioner"], NPC, 7274 };
		{ GREY.."6) "..AtlasLocale["Hydromancer Velratha"], NPC, 7795 };
		{ GREY..INDENT..AtlasLocale["Gahz'rilla"].." ("..AtlasLocale["Summon"]..")", NPC, 7273 };
		{ GREY..INDENT..AtlasLocale["Elder Wildmane"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15578 };
		{ GREY.."7) "..AtlasLocale["Chief Ukorz Sandscalp"], NPC, 7267 };
		{ GREY..INDENT..AtlasLocale["Ruuzlu"], NPC, 7797 };
		{ GREY.."8) "..AtlasLocale["Zerillis"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Wanders"]..")", NPC, 10082 };
		{ GREY.."9) "..AtlasLocale["Sandarr Dunereaver"].." ("..AtlasLocale["Rare"]..")", NPC, 10080 };
	};

--************************************************
-- Eastern Kingdoms Instances (Classic)
--************************************************
	
	BlackrockDepths = {
		ZoneName = { BabbleZone["Blackrock Mountain"]..": "..BabbleZone["Blackrock Depths"], 1584 };
		Location = { BabbleZone["Searing Gorge"].." / "..BabbleZone["Burning Steppes"], 51, 46 };
		LevelRange = "52-58";
		MinLevel = "40";
		PlayerLimit = "5";
		Acronym = AtlasLocale["BRD"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Shadowforge Key"], ITEM, 11000 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Prison Cell Key"].." ("..AtlasLocale["Jail Break!"]..")", ITEM, 11140 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Banner of Provocation"].." ("..AtlasLocale["Theldren"]..")", ITEM, 21986 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lord Roccor"], NPC, 9025 };
		{ GREY.."2) "..AtlasLocale["Kharan Mighthammer"], NPC, 9021 };
		{ GREY.."3) "..AtlasLocale["Commander Gor'shak <Kargath Expeditionary Force>"], NPC, 9020 };
		{ GREY.."4) "..AtlasLocale["Marshal Windsor"], NPC, 9023 };
		{ GREY.."5) "..AtlasLocale["High Interrogator Gerstahn <Twilight's Hammer Interrogator>"], NPC, 9018 };
		{ GREY.."6) "..AtlasLocale["Ring of Law"] };
		{ GREY..INDENT..AtlasLocale["Anub'shiah"].." ("..AtlasLocale["Random"]..")", NPC, 9031 };
		{ GREY..INDENT..AtlasLocale["Eviscerator"].." ("..AtlasLocale["Random"]..")", NPC, 9029 };
		{ GREY..INDENT..AtlasLocale["Gorosh the Dervish"].." ("..AtlasLocale["Random"]..")", NPC, 9027 };
		{ GREY..INDENT..AtlasLocale["Grizzle"].." ("..AtlasLocale["Random"]..")", NPC, 9028 };
		{ GREY..INDENT..AtlasLocale["Hedrum the Creeper"].." ("..AtlasLocale["Random"]..")", NPC, 9032 };
		{ GREY..INDENT..AtlasLocale["Ok'thor the Breaker"].." ("..AtlasLocale["Random"]..")", NPC, 9030 };
		{ GREY..INDENT..AtlasLocale["Theldren"].." ("..AtlasLocale["Summon"]..")", NPC, 16059 };
		{ GREY..INDENT..AtlasLocale["Lefty"], NPC, 16049 };
		{ GREY..INDENT..AtlasLocale["Malgen Longspear"], NPC, 16052 };
		{ GREY..INDENT..AtlasLocale["Gnashjaw <Malgen Longspear's Pet>"], NPC, 16095 };
		{ GREY..INDENT..AtlasLocale["Rotfang"], NPC, 16050 };
		{ GREY..INDENT..AtlasLocale["Va'jashni"], NPC, 16055 };
		{ GREY..INDENT..AtlasLocale["Houndmaster Grebmar"].." ("..AtlasLocale["Lower"]..")", NPC, 9319 };
		{ GREY..INDENT..AtlasLocale["Elder Morndeep"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15549 };
		{ GREY..INDENT..AtlasLocale["High Justice Grimstone"], NPC, 10096 };
		{ GREY.."7) "..AtlasLocale["Monument of Franclorn Forgewright"], OBJECT, 164689 };
		{ GREY..INDENT..AtlasLocale["Pyromancer Loregrain"], NPC, 9024 };
		{ GREY.."8) "..AtlasLocale["The Vault"] };
		{ GREY..INDENT..AtlasLocale["Warder Stilgiss"], NPC, 9041 };
		{ GREY..INDENT..AtlasLocale["Verek"], NPC, 9042 };
		{ GREY..INDENT..AtlasLocale["Watchman Doomgrip"], NPC, 9476 };
		{ GREY.."9) "..AtlasLocale["Fineous Darkvire <Chief Architect>"], NPC, 9056 };
		{ GREY.."10) "..AtlasLocale["The Black Anvil"] };
		{ GREY..INDENT..AtlasLocale["Lord Incendius"], NPC, 9017 };
		{ GREY.."11) "..AtlasLocale["Bael'Gar"], NPC, 9016 };
		{ GREY.."12) "..AtlasLocale["Shadowforge Lock"] };
		{ GREY.."13) "..AtlasLocale["General Angerforge"], NPC, 9033 };
		{ GREY.."14) "..AtlasLocale["Golem Lord Argelmach"], NPC, 8983 };
		{ GREY..INDENT..AtlasLocale["Field Repair Bot 74A"], NPC, 14337 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."15) "..AtlasLocale["The Grim Guzzler"] };
		{ GREY..INDENT..AtlasLocale["Hurley Blackbreath"], NPC, 9537 };
		{ GREY..INDENT..AtlasLocale["Lokhtos Darkbargainer <The Thorium Brotherhood>"], NPC, 12944 };
		{ GREY..INDENT..AtlasLocale["Mistress Nagmara"], NPC, 9500 };
		{ GREY..INDENT..AtlasLocale["Phalanx"], NPC, 9502 };
		{ GREY..INDENT..AtlasLocale["Plugger Spazzring"], NPC, 9499 };
		{ GREY..INDENT..AtlasLocale["Private Rocknot"], NPC, 9503 };
		{ GREY..INDENT..AtlasLocale["Ribbly Screwspigot"], NPC, 9543 };
		{ GREY..INDENT..AtlasLocale["Coren Direbrew"].." ("..AtlasLocale["Brewfest"]..")", NPC, 23872 };
		{ GREY..INDENT..AtlasLocale["Griz Gutshank <Arena Vendor>"], NPC, 28225 };
		{ GREY.."16) "..AtlasLocale["Ambassador Flamelash"], NPC, 9156 };
		{ GREY.."17) "..AtlasLocale["Panzor the Invincible"].." ("..AtlasLocale["Rare"]..")", NPC, 8923 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."18) "..AtlasLocale["Summoner's Tomb"] };
		{ GREY.."19) "..AtlasLocale["The Lyceum"] };
		{ GREY.."20) "..AtlasLocale["Magmus"], NPC, 9938 };
		{ GREY.."21) "..AtlasLocale["Emperor Dagran Thaurissan"], NPC, 9019 };
		{ GREY..INDENT..AtlasLocale["Princess Moira Bronzebeard <Princess of Ironforge>"], NPC, 8929 };
		{ GREY..INDENT..AtlasLocale["High Priestess of Thaurissan"], NPC, 10076 };
		{ GREY.."22) "..AtlasLocale["The Black Forge"] };
		{ GREY.."23) "..BabbleZone["Molten Core"], ZONE, 2717 };
		{ GREY..INDENT..AtlasLocale["Core Fragment"], OBJECT, 179553 };
		{ GREY.."24) "..AtlasLocale["Overmaster Pyron"], NPC, 9026 };
		{ GREY.."25) "..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
	};
	BlackrockSpireLower = {
		ZoneName = { BabbleZone["Blackrock Mountain"]..": "..BabbleZone["Blackrock Spire"].." ("..AtlasLocale["Lower"]..")", 1583 };
		Location = { BabbleZone["Searing Gorge"].." / "..BabbleZone["Burning Steppes"], 51, 46 };
		LevelRange = "54-60";
		MinLevel = "45";
		PlayerLimit = "10";
		Acronym = AtlasLocale["LBRS"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["DS2"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Blackrock Spire"].." ("..AtlasLocale["Upper"]..")", ZONE, 1583 };
		{ BLUE.."C-F) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Vaelan"].." ("..AtlasLocale["Upper"]..")", NPC, 10296 };
		{ GREY.."2) "..AtlasLocale["Warosh <The Cursed>"].." ("..AtlasLocale["Wanders"]..")", NPC, 10799 };
		{ GREY..INDENT..AtlasLocale["Elder Stonefort"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15560 };
		{ GREY.."3) "..AtlasLocale["Roughshod Pike"], OBJECT, 175886 };
		{ GREY.."4) "..AtlasLocale["Spirestone Butcher"].." ("..AtlasLocale["Rare"]..")", NPC, 9219 };
		{ GREY.."5) "..AtlasLocale["Highlord Omokk"], NPC, 9196 };
		{ GREY.."6) "..AtlasLocale["Spirestone Battle Lord"].." ("..AtlasLocale["Rare"]..")", NPC, 9218 };
		{ GREY..INDENT..AtlasLocale["Spirestone Lord Magus"].." ("..AtlasLocale["Rare"]..")", NPC, 9217 };
		{ GREY.."7) "..AtlasLocale["Shadow Hunter Vosh'gajin"], NPC, 9236 };
		{ GREY..INDENT..AtlasLocale["Fifth Mosh'aru Tablet"], OBJECT, 175949 };
		{ GREY.."8) "..AtlasLocale["Bijou"], NPC, 10257 };
		{ GREY.."9) "..AtlasLocale["War Master Voone"], NPC, 9237 };
		{ GREY..INDENT..AtlasLocale["Mor Grayhoof"].." ("..AtlasLocale["Summon"]..")", NPC, 16080 };
		{ GREY..INDENT..AtlasLocale["Sixth Mosh'aru Tablet"], OBJECT, 175950 };
		{ GREY.."10) "..AtlasLocale["Bijou's Belongings"], OBJECT, 175334 };
		{ GREY.."11) "..AtlasLocale["Human Remains"].." ("..AtlasLocale["Lower"]..")", OBJECT, 176090 };
		{ GREY..INDENT..AtlasLocale["Unfired Plate Gauntlets"].." ("..AtlasLocale["Lower"]..")", OBJECT, 176089 };
		{ GREY.."12) "..AtlasLocale["Bannok Grimaxe <Firebrand Legion Champion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9596 };
		{ GREY.."13) "..AtlasLocale["Mother Smolderweb"], NPC, 10596 };
		{ GREY.."14) "..AtlasLocale["Crystal Fang"].." ("..AtlasLocale["Rare"]..")", NPC, 10376 };
		{ GREY.."15) "..AtlasLocale["Urok's Tribute Pile"], OBJECT, 175621 };
		{ GREY..INDENT..AtlasLocale["Urok Doomhowl"].." ("..AtlasLocale["Summon"]..")", NPC, 10584 };
		{ GREY.."16) "..AtlasLocale["Quartermaster Zigris <Bloodaxe Legion>"], NPC, 9736 };
		{ GREY.."17) "..AtlasLocale["Halycon"], NPC, 10220 };
		{ GREY..INDENT..AtlasLocale["Gizrul the Slavener"], NPC, 10268 };
		{ GREY.."18) "..AtlasLocale["Ghok Bashguud <Bloodaxe Champion>"].." ("..AtlasLocale["Rare"]..")", NPC, 9718 };
		{ GREY.."19) "..AtlasLocale["Overlord Wyrmthalak"], NPC, 9568 };
		{ GREN.."1') "..AtlasLocale["Burning Felguard"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Summon"]..")", NPC, 10263 };
	};
	BlackrockSpireUpper = {
		ZoneName = { BabbleZone["Blackrock Mountain"]..": "..BabbleZone["Blackrock Spire"].." ("..AtlasLocale["Upper"]..")", 1583 };
		Location = { BabbleZone["Searing Gorge"].." / "..BabbleZone["Burning Steppes"], 51, 46 };
		LevelRange = "56-61";
		MinLevel = "45";
		PlayerLimit = "10";
		Acronym = AtlasLocale["UBRS"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["DS2"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleZone["Blackrock Spire"].." ("..AtlasLocale["Lower"]..")", ZONE, 1583 };
		{ BLUE.."C-E) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Pyroguard Emberseer"], NPC, 9816 };
		{ GREY.."2) "..AtlasLocale["Solakar Flamewreath"], NPC, 10264 };
		{ GREY..INDENT..AtlasLocale["Father Flame"], OBJECT, 175245 };
		{ GREY.."3) "..AtlasLocale["Darkstone Tablet"], OBJECT, 175385 };
		{ GREY..INDENT..AtlasLocale["Doomrigger's Coffer"], OBJECT, 175382 };
		{ GREY.."4) "..AtlasLocale["Jed Runewatcher <Blackhand Legion>"].." ("..AtlasLocale["Rare"]..")", NPC, 10509 };
		{ GREY.."5) "..AtlasLocale["Goraluk Anvilcrack <Blackhand Legion Armorsmith>"], NPC, 10899 };
		{ GREY.."6) "..AtlasLocale["Warchief Rend Blackhand"], NPC, 10429 };
		{ GREY..INDENT..AtlasLocale["Gyth <Rend Blackhand's Mount>"], NPC, 10339 };
		{ GREY.."7) "..AtlasLocale["Awbee"], NPC, 10740 };
		{ GREY.."8) "..AtlasLocale["The Beast"], NPC, 10430 };
		{ GREY..INDENT..AtlasLocale["Lord Valthalak"].." ("..AtlasLocale["Summon"]..")", NPC, 16042 };
		{ GREY..INDENT..AtlasLocale["Finkle Einhorn"], NPC, 10776 };
		{ GREY.."9) "..AtlasLocale["General Drakkisath"], NPC, 10363 };
		{ GREY..INDENT..AtlasLocale["Drakkisath's Brand"], OBJECT, 179880 };
		{ GREY.."10) "..BabbleZone["Blackwing Lair"], ZONE, 2677 };
	};
	BlackwingLair = {
		ZoneName = { BabbleZone["Blackrock Mountain"]..": "..BabbleZone["Blackwing Lair"], 2677 };
		Location = { BabbleZone["Searing Gorge"].." / "..BabbleZone["Burning Steppes"], 51, 46 };
		LevelRange = "60-70";
		MinLevel = "60";
		PlayerLimit = "40";
		Acronym = AtlasLocale["BWL"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Razorgore the Untamed"], NPC, 12435 };
		{ GREY.."2) "..AtlasLocale["Vaelastrasz the Corrupt"], NPC, 13020 };
		{ GREY.."3) "..AtlasLocale["Broodlord Lashlayer"], NPC, 12017 };
		{ GREY.."4) "..AtlasLocale["Firemaw"], NPC, 11983 };
		{ GREY.."5) "..AtlasLocale["Draconic for Dummies (Chapter VII)"], ITEM, 21109 };
		{ GREY.."6) "..AtlasLocale["Master Elemental Shaper Krixix"], NPC, 14401 };
		{ GREY.."7) "..AtlasLocale["Ebonroc"], NPC, 14601 };
		{ GREY.."8) "..AtlasLocale["Flamegor"], NPC, 11981 };
		{ GREY.."9) "..AtlasLocale["Chromaggus"], NPC, 14020 };
		{ GREY.."10) "..AtlasLocale["Nefarian"], NPC, 11583 };
	};
	Gnomeregan = {
		ZoneName = { BabbleZone["Gnomeregan"], 133 };
		Location = { BabbleZone["Dun Morogh"], 1 };
		LevelRange = "24-32";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Gnome"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Workshop Key"].." ("..AtlasLocale["Back"]..")", ITEM, 6893 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ GREY.."1) "..AtlasLocale["Blastmaster Emi Shortfuse"], NPC, 7998 };
		{ GREY..INDENT..AtlasLocale["Grubbis"], NPC, 7361 };
		{ GREY..INDENT..AtlasLocale["Chomper"], NPC, 6215 };
		{ GREY.."2) "..AtlasLocale["Clean Room"] };
		{ GREY..INDENT..AtlasLocale["Tink Sprocketwhistle <Engineering Supplies>"], NPC, 9676 };
		{ GREY..INDENT..AtlasLocale["The Sparklematic 5200"], OBJECT, 142487 };
		{ GREY..INDENT..AtlasLocale["Mail Box"] };
		{ GREY.."3) "..AtlasLocale["Kernobee"], NPC, 7850 };
		{ GREY..INDENT..AtlasLocale["Alarm-a-bomb 2600"], NPC, 7897 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-B"], OBJECT, 142475 };
		{ GREY.."4) "..AtlasLocale["Viscous Fallout"], NPC, 7079 };
		{ GREY.."5) "..AtlasLocale["Electrocutioner 6000"], NPC, 6235 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-C"], OBJECT, 142476 };
		{ GREY.."6) "..AtlasLocale["Crowd Pummeler 9-60"].." ("..AtlasLocale["Upper"]..")", NPC, 6229 };
		{ GREY..INDENT..AtlasLocale["Matrix Punchograph 3005-D"], OBJECT, 142696 };
		{ GREY.."7) "..AtlasLocale["Dark Iron Ambassador"], NPC, 6228 };
		{ GREY.."8) "..AtlasLocale["Mekgineer Thermaplugg"], NPC, 7800 };
	};
	MoltenCore = {
		ZoneName = { BabbleZone["Blackrock Mountain"]..": "..BabbleZone["Molten Core"], 2717 };
		Location = { BabbleZone["Searing Gorge"].." / "..BabbleZone["Burning Steppes"], 51, 46 };
		LevelRange = "60-70";
		MinLevel = "50";
		PlayerLimit = "40";
		Acronym = AtlasLocale["MC"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Hydraxian Waterlords"], FACTION, 749 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Lucifron"], NPC, 12118 };
		{ GREY.."2) "..AtlasLocale["Magmadar"], NPC, 11982 };
		{ GREY.."3) "..AtlasLocale["Gehennas"], NPC, 12259 };
		{ GREY.."4) "..AtlasLocale["Garr"], NPC, 12057 };
		{ GREY.."5) "..AtlasLocale["Shazzrah"], NPC, 12264 };
		{ GREY.."6) "..AtlasLocale["Baron Geddon"], NPC, 12056 };
		{ GREY.."7) "..AtlasLocale["Golemagg the Incinerator"], NPC, 11988 };
		{ GREY.."8) "..AtlasLocale["Sulfuron Harbinger"], NPC, 12098 };
		{ GREY.."9) "..AtlasLocale["Majordomo Executus"], NPC, 12018 };
		{ GREY.."10) "..AtlasLocale["Ragnaros"], NPC, 11502 };
	};
	Scholomance = {
		ZoneName = { BabbleZone["Scholomance"], 2057 };
		Location = { BabbleZone["Western Plaguelands"], 28 };
		LevelRange = "58-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Scholo"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Skeleton Key"], ITEM, 13704 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Viewing Room Key"].." ("..AtlasLocale["Viewing Room"]..")", ITEM, 13873 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Blood of Innocents"].." ("..AtlasLocale["Kirtonos the Herald"]..")", ITEM, 13523 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["DS2"]..")", ITEM, 22057 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Divination Scryer"].." ("..AtlasLocale["Death Knight Darkreaver"]..")", ITEM, 18746 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Blood Steward of Kirtonos"], NPC, 14861 };
		{ GREY..INDENT..AtlasLocale["The Deed to Southshore"], OBJECT, 176486 };
		{ GREY.."2) "..AtlasLocale["Kirtonos the Herald"].." ("..AtlasLocale["Summon"]..")", NPC, 10506 };
		{ GREY.."3) "..AtlasLocale["Jandice Barov"], NPC, 10503 };
		{ GREY.."4) "..AtlasLocale["The Deed to Tarren Mill"], OBJECT, 176487 };
		{ GREY.."5) "..AtlasLocale["Rattlegore"].." ("..AtlasLocale["Lower"]..")", NPC, 11622 };
		{ GREY..INDENT..AtlasLocale["Death Knight Darkreaver"].." ("..AtlasLocale["Summon"]..")", NPC, 14516 };
		{ GREY.."6) "..AtlasLocale["Marduk Blackpool"], NPC, 10433 };
		{ GREY..INDENT..AtlasLocale["Vectus"], NPC, 10432 };
		{ GREY.."7) "..AtlasLocale["Ras Frostwhisper"], NPC, 10508 };
		{ GREY..INDENT..AtlasLocale["The Deed to Brill"], OBJECT, 176484 };
		{ GREY..INDENT..AtlasLocale["Kormok"].." ("..AtlasLocale["Summon"]..")", NPC, 16118 };
		{ GREY.."8) "..AtlasLocale["Instructor Malicia"], NPC, 10505 };
		{ GREY.."9) "..AtlasLocale["Doctor Theolen Krastinov <The Butcher>"], NPC, 11261 };
		{ GREY.."10) "..AtlasLocale["Lorekeeper Polkelt"], NPC, 10901 };
		{ GREY.."11) "..AtlasLocale["The Ravenian"], NPC, 10507 };
		{ GREY.."12) "..AtlasLocale["Lord Alexei Barov"], NPC, 10504 };
		{ GREY..INDENT..AtlasLocale["The Deed to Caer Darrow"], OBJECT, 176485 };
		{ GREY.."13) "..AtlasLocale["Lady Illucia Barov"], NPC, 10502 };
		{ GREY.."14) "..AtlasLocale["Darkmaster Gandling"], NPC, 1853 };
		{ GREN.."1') "..AtlasLocale["Torch Lever"] };
		{ GREN.."2') "..AtlasLocale["Secret Chest"] };
		{ GREN.."3') "..AtlasLocale["Alchemy Lab"] };
	};
	ShadowfangKeep = {
		ZoneName = { BabbleZone["Shadowfang Keep"], 209 };
		Location = { BabbleZone["Silverpine Forest"], 130 };
		LevelRange = "17-25";
		MinLevel = "10";
		PlayerLimit = "10";
		Acronym = AtlasLocale["SFK"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Rethilgore <The Cell Keeper>"], NPC, 3914 };
		{ GREY..INDENT..AtlasLocale["Sorcerer Ashcrombe"], NPC, 3850 };
		{ GREY..INDENT..AtlasLocale["Deathstalker Adamant"], NPC, 3849 };
		{ GREY..INDENT..AtlasLocale["Landen Stilwell"], NPC, 17822 };
		{ GREY.."2) "..AtlasLocale["Investigator Fezzen Brasstacks"].." ("..AtlasLocale["Love is in the Air"]..")", NPC, 38208 };
		{ GREY.."3) "..AtlasLocale["Deathstalker Vincent"], NPC, 4444 };
		{ GREY.."4) "..AtlasLocale["Apothecary Trio"].." ("..AtlasLocale["Love is in the Air"]..")" };
		{ GREY..INDENT..AtlasLocale["Apothecary Hummel <Crown Chemical Co.>"], NPC, 36296 };
		{ GREY..INDENT..AtlasLocale["Apothecary Baxter <Crown Chemical Co.>"], NPC, 36565 };
		{ GREY..INDENT..AtlasLocale["Apothecary Frye <Crown Chemical Co.>"], NPC, 36272 };
		{ GREY.."5) "..AtlasLocale["Fel Steed"], NPC, 3864 };
		{ GREY..INDENT..AtlasLocale["Jordan's Hammer"], OBJECT, 91138 };
		{ GREY..INDENT..AtlasLocale["Crate of Ingots"], OBJECT, 182011 };
		{ GREY.."6) "..AtlasLocale["Razorclaw the Butcher"], NPC, 3886 };
		{ GREY.."7) "..AtlasLocale["Baron Silverlaine"], NPC, 3887 };
		{ GREY.."8) "..AtlasLocale["Commander Springvale"], NPC, 4278 };
		{ GREY.."9) "..AtlasLocale["Odo the Blindwatcher"], NPC, 4279 };
		{ GREY.."10) "..AtlasLocale["Deathsworn Captain"].." ("..AtlasLocale["Rare"]..")", NPC, 3872 };
		{ GREY.."11) "..AtlasLocale["Fenrus the Devourer"], NPC, 4274 };
		{ GREY..INDENT..AtlasLocale["Arugal's Voidwalker"], NPC, 4627 };
		{ GREY..INDENT..AtlasLocale["The Book of Ur"], OBJECT, 36738 };
		{ GREY.."12) "..AtlasLocale["Wolf Master Nandos"], NPC, 3927 };
		{ GREY.."13) "..AtlasLocale["Archmage Arugal"], NPC, 4275 };
	};
	SMArmory = {
		ZoneName = { BabbleZone["Scarlet Monastery"]..": "..BabbleZone["Armory"], 796 };
		Location = { BabbleZone["Tirisfal Glades"], 85 };
		LevelRange = "33-40";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Armory"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"], ITEM, 7146 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Herod <The Scarlet Champion>"], NPC, 3975 };
	};
	SMCathedral = {
		ZoneName = { BabbleZone["Scarlet Monastery"]..": "..BabbleZone["Cathedral"], 796 };
		Location = { BabbleZone["Tirisfal Glades"], 85 };
		LevelRange = "36-42";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Cath"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"], ITEM, 7146 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["High Inquisitor Fairbanks"], NPC, 4542 };
		{ GREY.."2) "..AtlasLocale["Scarlet Commander Mograine"], NPC, 3976 };
		{ GREY..INDENT..AtlasLocale["High Inquisitor Whitemane"], NPC, 3977 };
	};
	SMGraveyard = {
		ZoneName = { BabbleZone["Scarlet Monastery"]..": "..BabbleZone["Graveyard"], 796 };
		Location = { BabbleZone["Tirisfal Glades"], 85 };
		LevelRange = "28-35";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["GY"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Interrogator Vishas"], NPC, 3983 };
		{ GREY..INDENT..AtlasLocale["Vorrel Sengutz"], NPC, 3981 };
		{ GREY.."2) "..AtlasLocale["Pumpkin Shrine"].." ("..AtlasLocale["Hallow's End"]..")", OBJECT, 186267 };
		{ GREY..INDENT..AtlasLocale["Headless Horseman"].." ("..AtlasLocale["Summon"]..")", NPC, 23682 };
		{ GREY.."3) "..AtlasLocale["Bloodmage Thalnos"], NPC, 4543 };
		{ GREN.."1') "..AtlasLocale["Ironspine"].." ("..AtlasLocale["Rare"]..")", NPC, 6489 };
		{ GREN..INDENT..AtlasLocale["Azshir the Sleepless"].." ("..AtlasLocale["Rare"]..")", NPC, 6490 };
		{ GREN..INDENT..AtlasLocale["Fallen Champion"].." ("..AtlasLocale["Rare"]..")", NPC, 6488 };
	};
	SMLibrary = {
		ZoneName = { BabbleZone["Scarlet Monastery"]..": "..BabbleZone["Library"], 796 };
		Location = { BabbleZone["Tirisfal Glades"], 85 };
		LevelRange = "31-37";
		MinLevel = "20";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Lib"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Houndmaster Loksey"], NPC, 3974 };
		{ GREY.."2) "..AtlasLocale["Arcanist Doan"], NPC, 6487 };
	};
	Stratholme = {
		ZoneName = { BabbleZone["Stratholme"], 2017 };
		Location = { BabbleZone["Eastern Plaguelands"], 139 };
		LevelRange = "58-60";
		MinLevel = "45";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Strat"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Argent Dawn"], FACTION, 529 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Scarlet Key"].." ("..AtlasLocale["Living Side"]..")", ITEM, 7146 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key to the City"].." ("..AtlasLocale["Undead Side"]..")", ITEM, 12382 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Various Postbox Keys"].." ("..AtlasLocale["Postmaster Malown"]..")" };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Brazier of Invocation"].." ("..AtlasLocale["DS2"]..")", ITEM, 22057 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Side"]..")" };
		{ GREY.."1) "..AtlasLocale["Skul"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Varies"]..")", NPC, 10393 };
		{ GREY..INDENT..AtlasLocale["Stratholme Courier"], NPC, 11082 };
		{ GREY..INDENT..AtlasLocale["Fras Siabi"], NPC, 11058 };
		{ GREY.."2) "..AtlasLocale["Atiesh <Hand of Sargeras>"].." ("..AtlasLocale["Summon"]..")", NPC, 16387 };
		{ GREY.."3) "..AtlasLocale["Hearthsinger Forresten"].." ("..AtlasLocale["Varies"]..")", NPC, 10558 };
		{ GREY.."4) "..AtlasLocale["The Unforgiven"], NPC, 10516 };
		{ GREY.."5) "..AtlasLocale["Elder Farwhisper"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15607 };
		{ GREY.."6) "..AtlasLocale["Timmy the Cruel"], NPC, 10808 };
		{ GREY.."7) "..AtlasLocale["Malor the Zealous"], NPC, 11032 };
		{ GREY..INDENT..AtlasLocale["Malor's Strongbox"], OBJECT, 176112 };
		{ GREY.."8) "..AtlasLocale["Crimson Hammersmith"].." ("..AtlasLocale["Summon"]..")", NPC, 11120 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."9) "..AtlasLocale["Cannon Master Willey"], NPC, 10997 };
		{ GREY.."10) "..AtlasLocale["Archivist Galford"], NPC, 10811 };
		{ GREY.."11) "..AtlasLocale["Grand Crusader Dathrohan"], NPC, 10812 };
		{ GREY..INDENT..AtlasLocale["Balnazzar"], NPC, 10813 };
		{ GREY..INDENT..AtlasLocale["Sothos"].." ("..AtlasLocale["Summon"]..")", NPC, 16102 };
		{ GREY..INDENT..AtlasLocale["Jarien"].." ("..AtlasLocale["Summon"]..")", NPC, 16101 };
		{ GREY.."12) "..AtlasLocale["Magistrate Barthilas"].." ("..AtlasLocale["Varies"]..")", NPC, 10435 };
		{ GREY.."13) "..AtlasLocale["Aurius"], NPC, 10917 };
		{ GREY.."14) "..AtlasLocale["Stonespine"].." ("..AtlasLocale["Rare"]..")", NPC, 10809 };
		{ GREY.."15) "..AtlasLocale["Baroness Anastari"], NPC, 10436 };
		{ GREY..INDENT..AtlasLocale["Black Guard Swordsmith"].." ("..AtlasLocale["Summon"]..")", NPC, 11121 };
		{ GREY..INDENT..AtlasLocale["Blacksmithing Plans"], OBJECT, 173232 };
		{ GREY.."16) "..AtlasLocale["Nerub'enkan"], NPC, 10437 };
		{ GREY.."17) "..AtlasLocale["Maleki the Pallid"], NPC, 10438 };
		{ GREY.."18) "..AtlasLocale["Ramstein the Gorger"], NPC, 10439 };
		{ GREY.."19) "..AtlasLocale["Baron Rivendare"], NPC, 10440 };
		{ GREY..INDENT..AtlasLocale["Ysida Harmon"], NPC, 16031 };
		{ GREN.."1') "..AtlasLocale["Crusaders' Square Postbox"] };
		{ GREN.."2') "..AtlasLocale["Market Row Postbox"] };
		{ GREN.."3') "..AtlasLocale["Festival Lane Postbox"] };
		{ GREN.."4') "..AtlasLocale["Elders' Square Postbox"] };
		{ GREN.."5') "..AtlasLocale["King's Square Postbox"] };
		{ GREN.."6') "..AtlasLocale["Fras Siabi's Postbox"] };
		{ GREN..AtlasLocale["3rd Box Opened"]..": "..AtlasLocale["Postmaster Malown"], NPC, 11143 };
	};
	TheDeadmines = {
		ZoneName = { BabbleZone["The Deadmines"], 1581 };
		Location = { BabbleZone["Westfall"], 40 };
		LevelRange = "16-22";
		MinLevel = "10";
		PlayerLimit = "10";
		Acronym = AtlasLocale["VC"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Rhahk'Zor <The Foreman>"], NPC, 644 };
		{ GREY.."2) "..AtlasLocale["Miner Johnson"].." ("..AtlasLocale["Rare"]..")", NPC, 3586 };
		{ GREY.."3) "..AtlasLocale["Sneed <Lumbermaster>"], NPC, 643 };
		{ GREY..INDENT..AtlasLocale["Sneed's Shredder <Lumbermaster>"], NPC, 642 };
		{ GREY.."4) "..AtlasLocale["Gilnid <The Smelter>"], NPC, 1763 };
		{ GREY.."5) "..AtlasLocale["Defias Gunpowder"], OBJECT, 17155 };
		{ GREY.."6) "..AtlasLocale["Captain Greenskin"], NPC, 647 };
		{ GREY..INDENT..AtlasLocale["Edwin VanCleef <Defias Kingpin>"], NPC, 639 };
		{ GREY..INDENT..AtlasLocale["Mr. Smite <The Ship's First Mate>"], NPC, 646 };
		{ GREY..INDENT..AtlasLocale["Cookie <The Ship's Cook>"], NPC, 645 };
	};
	TheStockade = {
		ZoneName = { BabbleZone["The Stockade"], 717 };
		Location = { BabbleZone["Stormwind City"], 1519 };
		LevelRange = "21-27";
		MinLevel = "15";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Stocks"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Targorr the Dread"].." ("..AtlasLocale["Varies"]..")", NPC, 1696 };
		{ GREY.."2) "..AtlasLocale["Kam Deepfury"], NPC, 1666 };
		{ GREY.."3) "..AtlasLocale["Hamhock"], NPC, 1717 };
		{ GREY.."4) "..AtlasLocale["Bazil Thredd"], NPC, 1716 };
		{ GREY.."5) "..AtlasLocale["Dextren Ward"], NPC, 1663 };
		{ GREY.."6) "..AtlasLocale["Bruegal Ironknuckle"].." ("..AtlasLocale["Rare"]..")", NPC, 1720 };
	};
	TheSunkenTemple = {
		ZoneName = { BabbleZone["Sunken Temple"], 1417 };
		Location = { BabbleZone["Swamp of Sorrows"], 8 };
		LevelRange = "46-53";
		MinLevel = "35";
		PlayerLimit = "10";
		Acronym = AtlasLocale["ST"];
		{ ORNG..AtlasLocale["AKA"]..": "..BabbleZone["The Temple of Atal'Hakkar"] };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Yeh'kinya's Scroll"].." ("..AtlasLocale["Avatar of Hakkar"]..")", ITEM, 10818 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B-I) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Altar of Hakkar"], OBJECT, 148836 };
		{ GREY..INDENT..AtlasLocale["Atal'alarion <Guardian of the Idol>"], NPC, 8580 };
		{ GREY.."2) "..AtlasLocale["Dreamscythe"], NPC, 5721 };
		{ GREY..INDENT..AtlasLocale["Weaver"], NPC, 5720 };
		{ GREY.."3) "..AtlasLocale["Avatar of Hakkar"], NPC, 8443 };
		{ GREY.."4) "..AtlasLocale["Jammal'an the Prophet"], NPC, 5710 };
		{ GREY..INDENT..AtlasLocale["Ogom the Wretched"], NPC, 5711 };
		{ GREY.."5) "..AtlasLocale["Morphaz"], NPC, 5719 };
		{ GREY..INDENT..AtlasLocale["Hazzas"], NPC, 5722 };
		{ GREY.."6) "..AtlasLocale["Shade of Eranikus"], NPC, 5709 };
		{ GREY..INDENT..AtlasLocale["Essence Font"], OBJECT, 148512 };
		{ GREY.."7) "..AtlasLocale["Spawn of Hakkar"].." ("..AtlasLocale["Rare"]..")", NPC, 5708 };
		{ GREY.."8) "..AtlasLocale["Elder Starsong"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 15593 };
		{ GREN.."1'-6') "..AtlasLocale["Statue Activation Order"] };
		{ GREN.."7') "..AtlasLocale["Atal'ai Defenders"] };
		{ GREN..INDENT..AtlasLocale["Gasher"], NPC, 5713 };
		{ GREN..INDENT..AtlasLocale["Loro"], NPC, 5714 };
		{ GREN..INDENT..AtlasLocale["Hukku"], NPC, 5715 };
		{ GREN..INDENT..AtlasLocale["Zolo"], NPC, 5712 };
		{ GREN..INDENT..AtlasLocale["Mijan"], NPC, 5717 };
		{ GREN..INDENT..AtlasLocale["Zul'Lor"], NPC, 5716 };
	};
	Uldaman = {
		ZoneName = { BabbleZone["Uldaman"], 1337 };
		Location = { BabbleZone["Badlands"], 3 };
		LevelRange = "36-42";
		MinLevel = "30";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Ulda"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Staff of Prehistoria"].." ("..AtlasLocale["Ironaya"]..")", ITEM, 7733 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ GREY.."1) "..AtlasLocale["Baelog"], NPC, 6906 };
		{ GREY..INDENT..AtlasLocale["Eric \"The Swift\""], NPC, 6907 };
		{ GREY..INDENT..AtlasLocale["Olaf"], NPC, 6908 };
		{ GREY..INDENT..AtlasLocale["Baelog's Chest"], OBJECT, 123329 };
		{ GREY..INDENT..AtlasLocale["Conspicuous Urn"], OBJECT, 125477 };
		{ GREY.."2) "..AtlasLocale["Remains of a Paladin"], NPC, 6912 };
		{ GREY.."3) "..AtlasLocale["Revelosh"], NPC, 6910 };
		{ GREY.."4) "..AtlasLocale["Ironaya"], NPC, 7228 };
		{ GREY.."5) "..AtlasLocale["Obsidian Sentinel"], NPC, 7023 };
		{ GREY.."6) "..AtlasLocale["Annora <Enchanting Trainer>"], NPC, 11073 };
		{ GREY.."7) "..AtlasLocale["Ancient Stone Keeper"], NPC, 7206 };
		{ GREY.."8) "..AtlasLocale["Galgann Firehammer"], NPC, 7291 };
		{ GREY..INDENT..AtlasLocale["Tablet of Will"], OBJECT, 142088 };
		{ GREY..INDENT..AtlasLocale["Shadowforge Cache"], OBJECT, 113757 };
		{ GREY.."9) "..AtlasLocale["Grimlok <Stonevault Chieftain>"], NPC, 4854 };
		{ GREY.."10) "..AtlasLocale["Archaedas <Ancient Stone Watcher>"].." ("..AtlasLocale["Lower"]..")", NPC, 2748 };
		{ GREY.."11) "..AtlasLocale["The Discs of Norgannon"].." ("..AtlasLocale["Lower"]..")", OBJECT, 131474 };
		{ GREY..INDENT..AtlasLocale["Ancient Treasure"].." ("..AtlasLocale["Lower"]..")", OBJECT, 141979 };
	};
	ZulGurub = {
		ZoneName = { BabbleZone["Zul'Gurub"], 19 };
		Location = { BabbleZone["Stranglethorn Vale"], 33 };
		LevelRange = "56-70";
		MinLevel = "50";
		PlayerLimit = "20";
		Acronym = AtlasLocale["ZG"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Zandalar Tribe"], FACTION, 270 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Mudskunk Lure"].." ("..AtlasLocale["Gahz'ranka"]..")", ITEM, 19974 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Gurubashi Mojo Madness"].." ("..AtlasLocale["Edge of Madness"]..")", ITEM, 19931 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["High Priestess Jeklik"].." ("..AtlasLocale["Bat"]..")", NPC, 14517 };
		{ GREY.."2) "..AtlasLocale["High Priest Venoxis"].." ("..AtlasLocale["Snake"]..")", NPC, 14507 };
		{ GREY.."3) "..AtlasLocale["Zanza the Restless"], NPC, 15042 };
		{ GREY.."4) "..AtlasLocale["High Priestess Mar'li"].." ("..AtlasLocale["Spider"]..")", NPC, 14510 };
		{ GREY.."5) "..AtlasLocale["Bloodlord Mandokir"].." ("..AtlasLocale["Raptor"]..", "..AtlasLocale["Optional"]..")", NPC, 11382 };
		{ GREY..INDENT..AtlasLocale["Ohgan"], NPC, 14988 };
		{ GREY.."6) "..AtlasLocale["Edge of Madness"].." ("..AtlasLocale["Optional"]..")" };
		{ GREY..INDENT..AtlasLocale["Gri'lek"].." ("..AtlasLocale["Random"]..")", NPC, 15082 };
		{ GREY..INDENT..AtlasLocale["Hazza'rah"].." ("..AtlasLocale["Random"]..")", NPC, 15083 };
		{ GREY..INDENT..AtlasLocale["Renataki"].." ("..AtlasLocale["Random"]..")", NPC, 15084 };
		{ GREY..INDENT..AtlasLocale["Wushoolay"].." ("..AtlasLocale["Random"]..")", NPC, 15085 };
		{ GREY.."7) "..AtlasLocale["Gahz'ranka"].." ("..AtlasLocale["Optional"]..", "..AtlasLocale["Summon"]..")", NPC, 15114 };
		{ GREY.."8) "..AtlasLocale["High Priest Thekal"].." ("..AtlasLocale["Tiger"]..")", NPC, 14509 };
		{ GREY..INDENT..AtlasLocale["Zealot Zath"], NPC, 11348 };
		{ GREY..INDENT..AtlasLocale["Zealot Lor'Khan"], NPC, 11347 };
		{ GREY.."9) "..AtlasLocale["High Priestess Arlokk"].." ("..AtlasLocale["Panther"]..")", NPC, 14515 };
		{ GREY.."10) "..AtlasLocale["Jin'do the Hexxer"].." ("..AtlasLocale["Undead"]..", "..AtlasLocale["Optional"]..")", NPC, 11380 };
		{ GREY.."11) "..AtlasLocale["Hakkar"], NPC, 14834 };
		{ GREN.."1') "..AtlasLocale["Muddy Churning Waters"] };
	};

--************************************************
-- Burning Crusade Instances
--************************************************

	AuchAuchenaiCrypts = {
		ZoneName = { BabbleZone["Auchindoun"]..": "..BabbleZone["Auchenai Crypts"], 3790 };
		Location = { BabbleZone["Terokkar Forest"], 3519 };
		LevelRange = "64-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["AC"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Lower City"], FACTION, 1011 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Auchenai Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30633 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Shirrak the Dead Watcher"], NPC, 18371 };
		{ GREY.."2) "..AtlasLocale["Exarch Maladaar"], NPC, 18373 };
		{ GREY..INDENT..AtlasLocale["Avatar of the Martyred"], NPC, 18478 };
		{ GREY..INDENT..AtlasLocale["D'ore"], NPC, 19412 };
	};
	AuchManaTombs = {
		ZoneName = { BabbleZone["Auchindoun"]..": "..BabbleZone["Mana-Tombs"], 3792 };
		Location = { BabbleZone["Terokkar Forest"], 3519 };
		LevelRange = "63-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["MT"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Consortium"], FACTION, 933 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Auchenai Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30633 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Eye of Haramad"].." ("..AtlasLocale["Exalted"]..", "..AtlasLocale["Yor <Void Hound of Shaffar>"]..")", ITEM, 32092 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Pandemonius"], NPC, 18341 };
		{ GREY..INDENT..AtlasLocale["Shadow Lord Xiraxis"], NPC, 19666 };
		{ GREY.."2) "..AtlasLocale["Ambassador Pax'ivi"].." ("..AtlasLocale["Heroic"]..")", NPC, 22928 };
		{ GREY.."3) "..AtlasLocale["Tavarok"], NPC, 18343 };
		{ GREY.."4) "..AtlasLocale["Cryo-Engineer Sha'heen"], NPC, 19671 };
		{ GREY..INDENT..AtlasLocale["Ethereal Transporter Control Panel"], OBJECT, 183877 };
		{ GREY.."5) "..AtlasLocale["Nexus-Prince Shaffar"], NPC, 18344 };
		{ GREY..INDENT..AtlasLocale["Yor <Void Hound of Shaffar>"].." ("..AtlasLocale["Summon"]..", "..AtlasLocale["Heroic"]..")", NPC, 22930 };
	};
	AuchSethekkHalls = {
		ZoneName = { BabbleZone["Auchindoun"]..": "..BabbleZone["Sethekk Halls"], 3791 };
		Location = { BabbleZone["Terokkar Forest"], 3519 };
		LevelRange = "66-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Seth"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Lower City"], FACTION, 1011 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Auchenai Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30633 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Essence-Infused Moonstone"].." ("..AtlasLocale["Anzu"]..")", ITEM, 32449 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Darkweaver Syth"], NPC, 18472 };
		{ GREY..INDENT..AtlasLocale["Lakka"], NPC, 18956 };
		{ GREY.."2) "..AtlasLocale["The Saga of Terokk"], OBJECT, 183050 };
		{ GREY..INDENT..AtlasLocale["Anzu"].." ("..AtlasLocale["Summon"]..", "..AtlasLocale["Heroic"]..")", NPC, 23035 };
		{ GREY.."3) "..AtlasLocale["Talon King Ikiss"], NPC, 18473 };
	};
	AuchShadowLabyrinth = {
		ZoneName = { BabbleZone["Auchindoun"]..": "..BabbleZone["Shadow Labyrinth"], 3789 };
		Location = { BabbleZone["Terokkar Forest"], 3519 };
		LevelRange = "69-70";
		MinLevel = "65";
		PlayerLimit = "5";
		Acronym = AtlasLocale["SL"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Lower City"], FACTION, 1011 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Shadow Labyrinth Key"], ITEM, 27991 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Auchenai Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30633 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Spy To'gun"], NPC, 18891 };
		{ GREY.."2) "..AtlasLocale["Ambassador Hellmaw"], NPC, 18731 };
		{ GREY.."3) "..AtlasLocale["Blackheart the Inciter"], NPC, 18667 };
		{ GREY.."4) "..AtlasLocale["Grandmaster Vorpil"], NPC, 18732 };
		{ GREY..INDENT..AtlasLocale["The Codex of Blood"], OBJECT, 182947 };
		{ GREY.."5) "..AtlasLocale["Murmur"], NPC, 18708 };
		{ GREY.."6) "..AtlasLocale["Arcane Container"], OBJECT, 182196 };
		{ GREY..INDENT..AtlasLocale["First Fragment Guardian"], NPC, 22890 };
	};
	BlackTempleStart = {
		ZoneName = { BabbleZone["Black Temple"].." [A] ("..AtlasLocale["Start"]..")", 3959 };
		Location = { BabbleZone["Shadowmoon Valley"], 3520 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["BT"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Ashtongue Deathsworn"], FACTION, 1012 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Towards Reliquary of Souls"] };
		{ BLUE.."C) "..AtlasLocale["Towards Teron Gorefiend"] };
		{ BLUE.."D) "..AtlasLocale["Towards Illidan Stormrage"] };
		{ GREY.."1) "..AtlasLocale["Spirit of Olum"], NPC, 23411 };
		{ GREY.."2) "..AtlasLocale["High Warlord Naj'entus"], NPC, 22887 };
		{ GREY.."3) "..AtlasLocale["Supremus"], NPC, 22898 };
		{ GREY.."4) "..AtlasLocale["Shade of Akama"], NPC, 22841 };
		{ GREY.."5) "..AtlasLocale["Spirit of Udalo"], NPC, 23410 };
		{ GREY..INDENT..AtlasLocale["Aluyen <Reagents>"], NPC, 23157 };
		{ GREY..INDENT..AtlasLocale["Okuno <Ashtongue Deathsworn Quartermaster>"], NPC, 23159 };
		{ GREY..INDENT..AtlasLocale["Seer Kanai"], NPC, 23158 };
	};
	BlackTempleBasement = {
		ZoneName = { BabbleZone["Black Temple"].." [B] ("..AtlasLocale["Basement"]..")", 3959 };
		Location = { BabbleZone["Shadowmoon Valley"], 3520 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["BT"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Ashtongue Deathsworn"], FACTION, 1012 };
		{ BLUE.."B) "..AtlasLocale["Entrance"] };
		{ BLUE.."C) "..AtlasLocale["Entrance"] };
		{ GREY.."6) "..AtlasLocale["Gurtogg Bloodboil"], NPC, 22948 };
		{ GREY.."7) "..AtlasLocale["Reliquary of Souls"] };
		{ GREY..INDENT..AtlasLocale["Essence of Suffering"], NPC, 23418 };
		{ GREY..INDENT..AtlasLocale["Essence of Desire"], NPC, 23419 };
		{ GREY..INDENT..AtlasLocale["Essence of Anger"], NPC, 23420 };
		{ GREY.."8) "..AtlasLocale["Teron Gorefiend"], NPC, 22871 };
	};
	BlackTempleTop = {
		ZoneName = { BabbleZone["Black Temple"].." [C] ("..AtlasLocale["Top"]..")", 3959 };
		Location = { BabbleZone["Shadowmoon Valley"], 3520 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["BT"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Ashtongue Deathsworn"], FACTION, 1012 };
		{ BLUE.."D) "..AtlasLocale["Entrance"] };
		{ GREY.."9) "..AtlasLocale["Mother Shahraz"], NPC, 22947 };
		{ GREY.."10) "..AtlasLocale["The Illidari Council"], NPC, 23426 };
		{ GREY..INDENT..AtlasLocale["Lady Malande"].." ("..AtlasLocale["Priest"]..")", NPC, 22951 };
		{ GREY..INDENT..AtlasLocale["Gathios the Shatterer"].." ("..AtlasLocale["Paladin"]..")", NPC, 22949 };
		{ GREY..INDENT..AtlasLocale["High Nethermancer Zerevor"].." ("..AtlasLocale["Mage"]..")", NPC, 22950 };
		{ GREY..INDENT..AtlasLocale["Veras Darkshadow"].." ("..AtlasLocale["Rogue"]..")", NPC, 22952 };
		{ GREY.."11) "..AtlasLocale["Illidan Stormrage <The Betrayer>"], NPC, 22917 };
	};
	CFRSerpentshrineCavern = {
		ZoneName = { BabbleZone["Coilfang Reservoir"]..": "..BabbleZone["Serpentshrine Cavern"], 3607 };
		Location = { BabbleZone["Zangarmarsh"], 3521 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["SC"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Cenarion Expedition"], FACTION, 942 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Hydross the Unstable <Duke of Currents>"], NPC, 21216 };
		{ GREY.."2) "..AtlasLocale["The Lurker Below"], NPC, 21217 };
		{ GREY.."3) "..AtlasLocale["Leotheras the Blind"], NPC, 21215 };
		{ GREY.."4) "..AtlasLocale["Fathom-Lord Karathress"], NPC, 21214 };
		{ GREY..INDENT..AtlasLocale["Seer Olum"], NPC, 22820 };
		{ GREY.."5) "..AtlasLocale["Morogrim Tidewalker"], NPC, 21213 };
		{ GREY.."6) "..AtlasLocale["Lady Vashj <Coilfang Matron>"], NPC, 21212 };
	};
	CFRTheSlavePens = {
		ZoneName = { BabbleZone["Coilfang Reservoir"]..": "..BabbleZone["The Slave Pens"], 3717 };
		Location = { BabbleZone["Zangarmarsh"], 3521 };
		LevelRange = "61-69";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["SP"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Cenarion Expedition"], FACTION, 942 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Reservoir Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30623 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Ahune <The Frost Lord>"].." ("..AtlasLocale["Midsummer Festival"]..")", NPC, 25740 };
		{ GREY.."2) "..AtlasLocale["Mennu the Betrayer"], NPC, 17941 };
		{ GREY.."3) "..AtlasLocale["Weeder Greenthumb"], NPC, 17890 };
		{ GREY.."4) "..AtlasLocale["Skar'this the Heretic"].." ("..AtlasLocale["Heroic"]..")", NPC, 22421 };
		{ GREY.."5) "..AtlasLocale["Rokmar the Crackler"], NPC, 17991 };
		{ GREY.."6) "..AtlasLocale["Naturalist Bite"], NPC, 17893 };
		{ GREY.."7) "..AtlasLocale["Quagmirran"], NPC, 17942 };
	};
	CFRTheSteamvault = {
		ZoneName = { BabbleZone["Coilfang Reservoir"]..": "..BabbleZone["The Steamvault"], 3715 };
		Location = { BabbleZone["Zangarmarsh"], 3521 };
		LevelRange = "69-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["SV"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Cenarion Expedition"], FACTION, 942 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Reservoir Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30623 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Hydromancer Thespia"], NPC, 17797 };
		{ GREY..INDENT..AtlasLocale["Main Chambers Access Panel"] };
		{ GREY.."2) "..AtlasLocale["Arcane Container"], OBJECT, 182196 };
		{ GREY..INDENT..AtlasLocale["Second Fragment Guardian"], NPC, 22891 };
		{ GREY.."3) "..AtlasLocale["Mekgineer Steamrigger"], NPC, 17796 };
		{ GREY..INDENT..AtlasLocale["Main Chambers Access Panel"] };
		{ GREY.."4) "..AtlasLocale["Warlord Kalithresh"], NPC, 17798 };
	};
	CFRTheUnderbog = {
		ZoneName = { BabbleZone["Coilfang Reservoir"]..": "..BabbleZone["The Underbog"], 3716 };
		Location = { BabbleZone["Zangarmarsh"], 3521 };
		LevelRange = "62-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["UB"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Cenarion Expedition"], FACTION, 942 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Reservoir Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30623 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Hungarfen"], NPC, 17770 };
		{ GREY..INDENT..AtlasLocale["The Underspore"], OBJECT, 182054 };
		{ GREY.."2) "..AtlasLocale["Ghaz'an"], NPC, 18105 };
		{ GREY.."3) "..AtlasLocale["Earthbinder Rayge"], NPC, 17885 };
		{ GREY.."4) "..AtlasLocale["Swamplord Musel'ek"], NPC, 17826 };
		{ GREY..INDENT..AtlasLocale["Claw <Swamplord Musel'ek's Pet>"], NPC, 17827 };
		{ GREY.."5) "..AtlasLocale["The Black Stalker"], NPC, 17882 };
	};
	CoTBlackMorass = {
		ZoneName = { BabbleZone["Caverns of Time"]..": "..BabbleZone["The Black Morass"], 2366 };
		Location = { BabbleZone["Tanaris"], 440 };
		LevelRange = "68-70";
		MinLevel = "66";
		PlayerLimit = "5";
		Acronym = AtlasLocale["CoT2"];
		{ PURP..AtlasLocale["Event"]..": "..AtlasLocale["Opening of the Dark Portal"] };
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Keepers of Time"], FACTION, 989 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key of Time"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30635 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Sa'at <Keepers of Time>"], NPC, 20201 };
		{ ORNG.."X) "..AtlasLocale["Portal"].." ("..AtlasLocale["Spawn Point"]..")" };
		{ ORNG..INDENT..AtlasLocale["Wave 6"]..": "..AtlasLocale["Chrono Lord Deja"], NPC, 17879 };
		{ ORNG..INDENT..AtlasLocale["Wave 12"]..": "..AtlasLocale["Temporus"], NPC, 17880 };
		{ ORNG..INDENT..AtlasLocale["Wave 18"]..": "..AtlasLocale["Aeonus"], NPC, 17881 };
		{ GREY.."1) "..AtlasLocale["The Dark Portal"] };
		{ GREY..INDENT..AtlasLocale["Medivh"], NPC, 15608 };
	};
	CoTHyjal = {
		ZoneName = { BabbleZone["Caverns of Time"]..": "..BabbleZone["Hyjal Summit"], 3606 };
		Location = { BabbleZone["Tanaris"], 440 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["CoT3"];
		{ PURP..AtlasLocale["Event"]..": "..AtlasLocale["Battle for Mount Hyjal"] };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Scale of the Sands"], FACTION, 990 };
		{ BLUE.."A) "..AtlasLocale["Alliance Base"] };
		{ BLUE..INDENT..AtlasLocale["Lady Jaina Proudmoore"], NPC, 17772 };
		{ BLUE.."B) "..AtlasLocale["Horde Encampment"] };
		{ BLUE..INDENT..AtlasLocale["Thrall <Warchief>"], NPC, 17852 };
		{ BLUE.."C) "..AtlasLocale["Night Elf Village"] };
		{ BLUE..INDENT..AtlasLocale["Tyrande Whisperwind <High Priestess of Elune>"], NPC, 7999 };
		{ GREY.."1) "..AtlasLocale["Rage Winterchill"], NPC, 17767 };
		{ GREY.."2) "..AtlasLocale["Anetheron"], NPC, 17808 };
		{ GREY.."3) "..AtlasLocale["Kaz'rogal"], NPC, 17888 };
		{ GREY.."4) "..AtlasLocale["Azgalor"], NPC, 17842 };
		{ GREY.."5) "..AtlasLocale["Archimonde"], NPC, 17968 };
		{ GREY.."?) "..AtlasLocale["Indormi <Keeper of Ancient Gem Lore>"], NPC, 23437 };
		{ GREY..INDENT..AtlasLocale["Tydormu <Keeper of Lost Artifacts>"], NPC, 23381 };
	};
	CoTOldHillsbrad = {
		ZoneName = { BabbleZone["Caverns of Time"]..": "..BabbleZone["Old Hillsbrad Foothills"], 2367 };
		Location = { BabbleZone["Tanaris"], 440 };
		LevelRange = "66-70";
		MinLevel = "66";
		PlayerLimit = "5";
		Acronym = AtlasLocale["CoT1"];
		{ PURP..AtlasLocale["Event"]..": "..AtlasLocale["Escape from Durnholde Keep"] };
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Keepers of Time"], FACTION, 989 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key of Time"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30635 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Erozion"], NPC, 18723 };
		{ BLUE..INDENT..AtlasLocale["Brazen"], NPC, 18725 };
		{ BLUE.."B) "..AtlasLocale["Landing Spot"] };
		{ BLUE.."C) "..BabbleSubZone["Southshore"] };
		{ BLUE.."D) "..BabbleSubZone["Tarren Mill"] };
		{ GREY.."1) "..AtlasLocale["Lieutenant Drake"], NPC, 17848 };
		{ GREY.."2) "..AtlasLocale["Thrall"].." ("..AtlasLocale["Lower"]..")", NPC, 17876 };
		{ GREY.."3) "..AtlasLocale["Captain Skarloc"], NPC, 17862 };
		{ GREY..INDENT..AtlasLocale["Thrall"].." ("..AtlasLocale["Second Stop"]..")", NPC, 17876 };
		{ GREY.."4) "..AtlasLocale["Thrall"].." ("..AtlasLocale["Third Stop"]..")", NPC, 17876 };
		{ GREY.."5) "..AtlasLocale["Epoch Hunter"], NPC, 18096 };
		{ GREY..INDENT..AtlasLocale["Thrall"].." ("..AtlasLocale["Fourth Stop"]..", "..AtlasLocale["Upper"]..")", NPC, 17876 };
		{ GREY..INDENT..AtlasLocale["Taretha"].." ("..AtlasLocale["Upper"]..")", NPC, 18887 };
		{ GREY.."6) "..AtlasLocale["Jonathan Revah"], NPC, 20372 };
		{ GREY..INDENT..AtlasLocale["Jerry Carter"], NPC, 20376 };
		{ "" };
		{ ORNG..AtlasLocale["Traveling"] };
		{ GREY..INDENT..AtlasLocale["Thomas Yance <Travelling Salesman>"], NPC, 18672 };
		{ GREY..INDENT..AtlasLocale["Aged Dalaran Wizard"], NPC, 18664 };
		{ GREY..INDENT..AtlasLocale["Don Carlos"], NPC, 28132 };
		{ GREY..INDENT..AtlasLocale["Guerrero"], NPC, 28163 };
		{ "" };
		{ ORNG..BabbleSubZone["Southshore"] };
		{ GREY..INDENT..AtlasLocale["Kel'Thuzad <The Kirin Tor>"], NPC, 20350 };
		{ GREY..INDENT..AtlasLocale["Helcular"], NPC, 20353 };
		{ GREY..INDENT..AtlasLocale["Farmer Kent"], NPC, 20368 };
		{ GREY..INDENT..AtlasLocale["Sally Whitemane"], NPC, 20357 };
		{ GREY..INDENT..AtlasLocale["Renault Mograine"], NPC, 20358 };
		{ GREY..INDENT..AtlasLocale["Little Jimmy Vishas"], NPC, 20359 };
		{ GREY..INDENT..AtlasLocale["Herod the Bully"], NPC, 20360 };
		{ GREY..INDENT..AtlasLocale["Nat Pagle"], NPC, 20344 };
		{ GREY..INDENT..AtlasLocale["Hal McAllister"], NPC, 20342 };
		{ GREY..INDENT..AtlasLocale["Zixil <Aspiring Merchant>"], NPC, 20419 };
		{ GREY..INDENT..AtlasLocale["Overwatch Mark 0 <Protector>"], NPC, 20420 };
		{ "" };
		{ ORNG..AtlasLocale["Southshore Inn"] };
		{ GREY..INDENT..AtlasLocale["Captain Edward Hanes"], NPC, 20400 };
		{ GREY..INDENT..AtlasLocale["Captain Sanders"], NPC, 20351 };
		{ GREY..INDENT..AtlasLocale["Commander Mograine"], NPC, 20345 };
		{ GREY..INDENT..AtlasLocale["Isillien"], NPC, 20346 };
		{ GREY..INDENT..AtlasLocale["Abbendis"], NPC, 20347 };
		{ GREY..INDENT..AtlasLocale["Fairbanks"], NPC, 20348 };
		{ GREY..INDENT..AtlasLocale["Tirion Fordring"], NPC, 20349 };
		{ GREY..INDENT..AtlasLocale["Arcanist Doan"], NPC, 20352 };
		{ GREY..INDENT..AtlasLocale["Taelan"].." ("..AtlasLocale["Upper"]..")", NPC, 20361 };
		{ GREY..INDENT..AtlasLocale["Barkeep Kelly <Bartender>"], NPC, 20377 };
		{ GREY..INDENT..AtlasLocale["Frances Lin <Barmaid>"], NPC, 20401 };
		{ GREY..INDENT..AtlasLocale["Chef Jessen <Speciality Meat & Slop>"], NPC, 20378 };
		{ GREY..INDENT..AtlasLocale["Stalvan Mistmantle"].." ("..AtlasLocale["Upper"]..")", NPC, 20355 };
		{ GREY..INDENT..AtlasLocale["Phin Odelic <The Kirin Tor>"].." ("..AtlasLocale["Upper"]..")", NPC, 20370 };
		{ "" };
		{ ORNG..BabbleSubZone["Southshore Town Hall"] };
		{ GREY..INDENT..AtlasLocale["Magistrate Henry Maleb"], NPC, 20373 };
		{ GREY..INDENT..AtlasLocale["Raleigh the True"], NPC, 20380 };
		{ GREY..INDENT..AtlasLocale["Nathanos Marris"], NPC, 20354 };
		{ GREY..INDENT..AtlasLocale["Bilger the Straight-laced"], NPC, 20379 };
		{ "" };
		{ ORNG..BabbleSubZone["Tarren Mill"] };
		{ GREY..INDENT..AtlasLocale["Innkeeper Monica"], NPC, 18649 };
		{ GREY..INDENT..AtlasLocale["Julie Honeywell"], NPC, 18656 };
		{ GREY..INDENT..AtlasLocale["Jay Lemieux"], NPC, 18655 };
		{ GREY..INDENT..AtlasLocale["Young Blanchy"], NPC, 18651 };
	};
	GruulsLair = {
		ZoneName = { BabbleZone["Gruul's Lair"], 3618 };
		Location = { BabbleZone["Blade's Edge Mountains"], 3522 };
		LevelRange = "70";
		MinLevel = "65";
		PlayerLimit = "25";
		Acronym = AtlasLocale["GL"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["High King Maulgar <Lord of the Ogres>"], NPC, 18831 };
		{ GREY..INDENT..AtlasLocale["Kiggler the Crazed"].." ("..AtlasLocale["Shaman"]..")", NPC, 18835 };
		{ GREY..INDENT..AtlasLocale["Blindeye the Seer"].." ("..AtlasLocale["Priest"]..")", NPC, 18836 };
		{ GREY..INDENT..AtlasLocale["Olm the Summoner"].." ("..AtlasLocale["Warlock"]..")", NPC, 18834 };
		{ GREY..INDENT..AtlasLocale["Krosh Firehand"].." ("..AtlasLocale["Mage"]..")", NPC, 18832 };
		{ GREY.."2) "..AtlasLocale["Gruul the Dragonkiller"], NPC, 19044 };
	};
	HCBloodFurnace = {
		ZoneName = { BabbleZone["Hellfire Citadel"]..": "..BabbleZone["The Blood Furnace"], 3713 };
		Location = { BabbleZone["Hellfire Peninsula"], 3483 };
		LevelRange = "60-68";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["BF"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Thrallmar"].." ("..AtlasLocale["Horde"]..")", FACTION, 947 };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Honor Hold"].." ("..AtlasLocale["Alliance"]..")", FACTION, 946 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Flamewrought Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30637 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["The Maker"], NPC, 17381 };
		{ GREY.."2) "..AtlasLocale["Broggok"], NPC, 17380 };
		{ GREY.."3) "..AtlasLocale["Keli'dan the Breaker"], NPC, 17377 };
	};
	HCHellfireRamparts = {
		ZoneName = { BabbleZone["Hellfire Citadel"]..": "..BabbleZone["Hellfire Ramparts"], 3562 };
		Location = { BabbleZone["Hellfire Peninsula"], 3483 };
		LevelRange = "59-67";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Ramp"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Thrallmar"].." ("..AtlasLocale["Horde"]..")", FACTION, 947 };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Honor Hold"].." ("..AtlasLocale["Alliance"]..")", FACTION, 946 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Flamewrought Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30637 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Watchkeeper Gargolmar"], NPC, 17306 };
		{ GREY.."2) "..AtlasLocale["Omor the Unscarred"], NPC, 17308 };
		{ GREY.."3) "..AtlasLocale["Vazruden"], NPC, 17537 };
		{ GREY..INDENT..AtlasLocale["Nazan <Vazruden's Mount>"], NPC, 17536 };
		{ GREY..INDENT..AtlasLocale["Reinforced Fel Iron Chest"], OBJECT, 185168 };
	};
	HCMagtheridonsLair = {
		ZoneName = { BabbleZone["Hellfire Citadel"]..": "..BabbleZone["Magtheridon's Lair"], 3836 };
		Location = { BabbleZone["Hellfire Peninsula"], 3483 };
		LevelRange = "70";
		MinLevel = "65";
		PlayerLimit = "25";
		Acronym = AtlasLocale["Mag"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Magtheridon"], NPC, 17257 };
	};
	HCTheShatteredHalls = {
		ZoneName = { BabbleZone["Hellfire Citadel"]..": "..BabbleZone["The Shattered Halls"], 3714 };
		Location = { BabbleZone["Hellfire Peninsula"], 3483 };
		LevelRange = "69-70";
		MinLevel = "55";
		PlayerLimit = "5";
		Acronym = AtlasLocale["SH"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Thrallmar"].." ("..AtlasLocale["Horde"]..")", FACTION, 947 };
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Honor Hold"].." ("..AtlasLocale["Alliance"]..")", FACTION, 946 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Shattered Halls Key"], ITEM, 28395 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Flamewrought Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30637 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Randy Whizzlesprocket"].." ("..AtlasLocale["Alliance"]..", "..AtlasLocale["Heroic"]..")", NPC, 17288 };
		{ GREY..INDENT..AtlasLocale["Drisella"].." ("..AtlasLocale["Horde"]..", "..AtlasLocale["Heroic"]..")", NPC, 17294 };
		{ GREY.."2) "..AtlasLocale["Grand Warlock Nethekurse"], NPC, 16807 };
		{ GREY.."3) "..AtlasLocale["Blood Guard Porung"].." ("..AtlasLocale["Heroic"]..")", NPC, 20923 };
		{ GREY.."4) "..AtlasLocale["Warbringer O'mrogg"], NPC, 16809 };
		{ GREY.."5) "..AtlasLocale["Warchief Kargath Bladefist"], NPC, 16808 };
		{ GREY..INDENT..AtlasLocale["Shattered Hand Executioner"].." ("..AtlasLocale["Heroic"]..")", NPC, 17301 };
		{ GREY..INDENT..AtlasLocale["Private Jacint"].." ("..AtlasLocale["Alliance"]..", "..AtlasLocale["Heroic"]..")", NPC, 17292 };
		{ GREY..INDENT..AtlasLocale["Rifleman Brownbeard"].." ("..AtlasLocale["Alliance"]..", "..AtlasLocale["Heroic"]..")", NPC, 17289 };
		{ GREY..INDENT..AtlasLocale["Captain Alina"].." ("..AtlasLocale["Alliance"]..", "..AtlasLocale["Heroic"]..")", NPC, 17290 };
		{ GREY..INDENT..AtlasLocale["Scout Orgarr"].." ("..AtlasLocale["Horde"]..", "..AtlasLocale["Heroic"]..")", NPC, 17297 };
		{ GREY..INDENT..AtlasLocale["Korag Proudmane"].." ("..AtlasLocale["Horde"]..", "..AtlasLocale["Heroic"]..")", NPC, 17295 };
		{ GREY..INDENT..AtlasLocale["Captain Boneshatter"].." ("..AtlasLocale["Horde"]..", "..AtlasLocale["Heroic"]..")", NPC, 17296 };
	};
	KarazhanStart = {
		ZoneName = { BabbleZone["Karazhan"].." [A] ("..AtlasLocale["Start"]..")", 2562 };
		Location = { BabbleZone["Deadwind Pass"], 41 };
		LevelRange = "70";
		MinLevel = "68";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Kara"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Violet Eye"], FACTION, 967 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Master's Key"], ITEM, 24490 };
		{ BLUE.."A) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Front"]..")" };
		{ BLUE.."B) "..AtlasLocale["Staircase to the Ballroom"].." ("..AtlasLocale["Moroes <Tower Steward>"]..")" };
		{ BLUE.."C) "..AtlasLocale["Stairs to Upper Stable"] };
		{ BLUE.."D) "..AtlasLocale["Ramp to the Guest Chambers"].." ("..AtlasLocale["Maiden of Virtue"]..")" };
		{ BLUE.."E) "..AtlasLocale["Stairs to Opera House Orchestra Level"] };
		{ BLUE.."F) "..AtlasLocale["Ramp from Mezzanine to Balcony"] };
		{ BLUE.."G) "..AtlasLocale["Entrance"].." ("..AtlasLocale["Back"]..")" };
		{ BLUE.."H) "..AtlasLocale["Connection to Master's Terrace"].." ("..AtlasLocale["Nightbane"]..")" };
		{ BLUE.."I) "..AtlasLocale["Path to the Broken Stairs"] };
		{ GREY.."1) "..AtlasLocale["Hastings <The Caretaker>"], NPC, 16169 };
		{ GREY.."2) "..AtlasLocale["Servant Quarters"] };
		{ GREY..INDENT..AtlasLocale["Hyakiss the Lurker"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Random"]..")", NPC, 16179 };
		{ GREY..INDENT..AtlasLocale["Rokad the Ravager"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Random"]..")", NPC, 16181 };
		{ GREY..INDENT..AtlasLocale["Shadikith the Glider"].." ("..AtlasLocale["Rare"]..", "..AtlasLocale["Random"]..")", NPC, 16180 };
		{ GREY.."3) "..AtlasLocale["Berthold <The Doorman>"], NPC, 16153 };
		{ GREY.."4) "..AtlasLocale["Calliard <The Nightman>"], NPC, 16159 };
		{ GREY.."5) "..AtlasLocale["Attumen the Huntsman"], NPC, 15550 };
		{ GREY..INDENT..AtlasLocale["Midnight"], NPC, 16151 };
		{ GREY.."6) "..AtlasLocale["Koren <The Blacksmith>"], NPC, 16388 };
		{ GREY.."7) "..AtlasLocale["Moroes <Tower Steward>"], NPC, 15687 };
		{ GREY..INDENT..AtlasLocale["Baroness Dorothea Millstipe"].." ("..AtlasLocale["Random"]..", "..AtlasLocale["Shadow Priest"]..")", NPC, 19875 };
		{ GREY..INDENT..AtlasLocale["Lady Catriona Von'Indi"].." ("..AtlasLocale["Random"]..", "..AtlasLocale["Holy Priest"]..")", NPC, 19872 };
		{ GREY..INDENT..AtlasLocale["Lady Keira Berrybuck"].." ("..AtlasLocale["Random"]..", "..AtlasLocale["Holy Paladin"]..")", NPC, 17007 };
		{ GREY..INDENT..AtlasLocale["Baron Rafe Dreuger"].." ("..AtlasLocale["Random"]..", "..AtlasLocale["Retribution Paladin"]..")", NPC, 19874 };
		{ GREY..INDENT..AtlasLocale["Lord Robin Daris"].." ("..AtlasLocale["Random"]..", "..AtlasLocale["Arms Warrior"]..")", NPC, 19876 };
		{ GREY..INDENT..AtlasLocale["Lord Crispin Ference"].." ("..AtlasLocale["Random"]..", "..AtlasLocale["Protection Warrior"]..")", NPC, 19873 };
		{ GREY.."8) "..AtlasLocale["Bennett <The Sergeant at Arms>"], NPC, 16426 };
		{ GREY.."9) "..AtlasLocale["Ebonlocke <The Noble>"], NPC, 16806 };
		{ GREY.."10) "..AtlasLocale["Keanna's Log"], OBJECT, 182199 };
		{ GREY.."11) "..AtlasLocale["Maiden of Virtue"], NPC, 16457 };
		{ GREY.."12) "..AtlasLocale["Sebastian <The Organist>"], NPC, 16811 };
		{ GREY.."13) "..AtlasLocale["Barnes <The Stage Manager>"], NPC, 16812 };
		{ GREY.."14) "..AtlasLocale["The Opera Event"] };
		{ GREY..INDENT..AtlasLocale["Red Riding Hood"].." ("..AtlasLocale["Random"]..")" };
		{ GREY..INDENT..INDENT..AtlasLocale["The Big Bad Wolf"], NPC, 17521 };
		{ GREY..INDENT..AtlasLocale["Wizard of Oz"].." ("..AtlasLocale["Random"]..")" };
		{ GREY..INDENT..INDENT..AtlasLocale["Dorothee"], NPC, 17535 };
		{ GREY..INDENT..INDENT..AtlasLocale["Tito"], NPC, 17548 };
		{ GREY..INDENT..INDENT..AtlasLocale["Strawman"], NPC, 17543 };
		{ GREY..INDENT..INDENT..AtlasLocale["Tinhead"], NPC, 17547 };
		{ GREY..INDENT..INDENT..AtlasLocale["Roar"], NPC, 17546 };
		{ GREY..INDENT..INDENT..AtlasLocale["The Crone"], NPC, 18168 };
		{ GREY..INDENT..AtlasLocale["Romulo and Julianne"].." ("..AtlasLocale["Random"]..")" };
		{ GREY..INDENT..INDENT..AtlasLocale["Romulo"], NPC, 17533 };
		{ GREY..INDENT..INDENT..AtlasLocale["Julianne"], NPC, 17534 };
		{ GREY.."15) "..AtlasLocale["The Master's Terrace"] };
		{ GREY..INDENT..AtlasLocale["Nightbane"].." ("..AtlasLocale["Summon"]..")", NPC, 17225 };
	};
	KarazhanEnd = {
		ZoneName = { BabbleZone["Karazhan"].." [B] ("..AtlasLocale["End"]..")", 2562 };
		Location = { BabbleZone["Deadwind Pass"], 41 };
		LevelRange = "70";
		MinLevel = "68";
		PlayerLimit = "10";
		Acronym = AtlasLocale["Kara"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Violet Eye"], FACTION, 967 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Master's Key"], ITEM, 24490 };
		{ BLUE.."I) "..AtlasLocale["Path to the Broken Stairs"] };
		{ BLUE.."J) "..AtlasLocale["Broken Stairs"] };
		{ BLUE.."K) "..AtlasLocale["Ramp to Guardian's Library"].." ("..AtlasLocale["Shade of Aran"]..")" };
		{ BLUE.."L) "..AtlasLocale["Suspicious Bookshelf"].." ("..AtlasLocale["Terestian Illhoof"]..")" };
		{ BLUE.."M) "..AtlasLocale["Ramp up to the Celestial Watch"].." ("..AtlasLocale["Netherspite"]..")" };
		{ BLUE..INDENT..AtlasLocale["Ramp down to the Gamesman's Hall"].." ("..AtlasLocale["Chess Event"]..")" };
		{ BLUE.."N) "..AtlasLocale["Ramp to Medivh's Chamber"] };
		{ BLUE.."O) "..AtlasLocale["Spiral Stairs to Netherspace"].." ("..AtlasLocale["Prince Malchezaar"]..")" };
		{ GREY.."16) "..AtlasLocale["The Curator"], NPC, 15691 };
		{ GREY.."17) "..AtlasLocale["Wravien <The Mage>"], NPC, 16813 };
		{ GREY.."18) "..AtlasLocale["Gradav <The Warlock>"], NPC, 16814 };
		{ GREY.."19) "..AtlasLocale["Kamsis <The Conjurer>"], NPC, 16815 };
		{ GREY.."20) "..AtlasLocale["Terestian Illhoof"], NPC, 15688 };
		{ GREY..INDENT..AtlasLocale["Kil'rek"].." ("..AtlasLocale["Imp"]..")", NPC, 17229 };
		{ GREY.."21) "..AtlasLocale["Shade of Aran"], NPC, 16524 };
		{ GREY.."22) "..AtlasLocale["Netherspite"], NPC, 15689 };
		{ GREY.."23) "..AtlasLocale["Ythyar"].." ("..AtlasLocale["Repair"]..", "..AtlasLocale["Rewards"]..")", NPC, 17518 };
		{ GREY.."24) "..AtlasLocale["Echo of Medivh"], NPC, 16816 };
		{ GREY.."25) "..AtlasLocale["Dust Covered Chest"].." ("..AtlasLocale["Chess Event"]..")", OBJECT, 185119 };
		{ GREY.."26) "..AtlasLocale["Prince Malchezaar"], NPC, 15690 };
	};
	MagistersTerrace = {
		ZoneName = { BabbleZone["Magisters' Terrace"], 4095 };
		Location = { BabbleZone["Isle of Quel'Danas"], 4080 };
		LevelRange = "70";
		MinLevel = "68";
		PlayerLimit = "5";
		Acronym = AtlasLocale["MaT"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["Shattered Sun Offensive"], FACTION, 1077 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Selin Fireheart"], NPC, 24723 };
		{ GREY..INDENT..AtlasLocale["Fel Crystals"], NPC, 24722 };
		{ GREY.."2) "..AtlasLocale["Tyrith"], NPC, 24822 };
		{ GREY.."3) "..AtlasLocale["Vexallus"], NPC, 24744 };
		{ GREY.."4) "..AtlasLocale["Scrying Orb"] };
		{ GREY..INDENT..AtlasLocale["Kalecgos"], NPC, 24850 };
		{ GREY.."5) "..AtlasLocale["Priestess Delrissa"].." ("..AtlasLocale["Lower"]..")", NPC, 24560 };
		{ GREY..INDENT..AtlasLocale["Apoko"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Shaman"]..")", NPC, 24553 };
		{ GREY..INDENT..AtlasLocale["Eramas Brightblaze"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Monk"]..")", NPC, 24554 };
		{ GREY..INDENT..AtlasLocale["Ellrys Duskhallow"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Warlock"]..")", NPC, 24558 };
		{ GREY..INDENT..INDENT..AtlasLocale["Fizzle"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..")", NPC, 24656 };
		{ GREY..INDENT..AtlasLocale["Garaxxas"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Hunter"]..")", NPC, 24555 };
		{ GREY..INDENT..INDENT..AtlasLocale["Sliver <Garaxxas' Pet>"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..")", NPC, 24552 };
		{ GREY..INDENT..AtlasLocale["Kagani Nightstrike"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Rogue"]..")", NPC, 24557 };
		{ GREY..INDENT..AtlasLocale["Warlord Salaris"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Warrior"]..")", NPC, 24559 };
		{ GREY..INDENT..AtlasLocale["Yazzai"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Mage"]..")", NPC, 24561 };
		{ GREY..INDENT..AtlasLocale["Zelfan"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..", "..AtlasLocale["Engineer"]..")", NPC, 24556 };
		{ GREY.."6) "..AtlasLocale["Kael'thas Sunstrider <Lord of the Blood Elves>"], NPC, 24664 };
	};
	SunwellPlateau = {
		ZoneName = { BabbleZone["Sunwell Plateau"], 4075 };
		Location = { BabbleZone["Isle of Quel'Danas"], 4080 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["SuP"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Kalecgos"], NPC, 24850 };
		{ GREY..INDENT..AtlasLocale["Sathrovarr the Corruptor"], NPC, 24892 };
		{ GREY.."2) "..AtlasLocale["Madrigosa"], NPC, 24895 };
		{ GREY..INDENT..AtlasLocale["Brutallus"], NPC, 24882 };
		{ GREY..INDENT..AtlasLocale["Felmyst"], NPC, 25038 };
		{ GREY.."3) "..AtlasLocale["Eredar Twins"].." ("..AtlasLocale["Lower"]..")" };
		{ GREY..INDENT..AtlasLocale["Grand Warlock Alythess"].." ("..AtlasLocale["Lower"]..")", NPC, 25166 };
		{ GREY..INDENT..AtlasLocale["Lady Sacrolash"].." ("..AtlasLocale["Lower"]..")", NPC, 25165 };
		{ GREY..INDENT..AtlasLocale["M'uru"].." ("..AtlasLocale["Upper"]..")", NPC, 25741 };
		{ GREY..INDENT..AtlasLocale["Entropius"].." ("..AtlasLocale["Upper"]..")", NPC, 25840 };
		{ GREY.."4) "..AtlasLocale["Kil'jaeden <The Deceiver>"], NPC, 25315 };
	};
	TempestKeepArcatraz = {
		ZoneName = { BabbleZone["Tempest Keep"]..": "..BabbleZone["The Arcatraz"], 3846 };
		Location = { BabbleZone["Netherstorm"], 3523 };
		LevelRange = "69-70";
		MinLevel = "68";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Arca"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Sha'tar"], FACTION, 935 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key to the Arcatraz"], ITEM, 31084 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Warpforged Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30634 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Zereketh the Unbound"], NPC, 20870 };
		{ GREY.."2) "..AtlasLocale["Arcane Container"], OBJECT, 182196 };
		{ GREY..INDENT..AtlasLocale["Third Fragment Guardian"], NPC, 22892 };
		{ GREY.."3) "..AtlasLocale["Dalliah the Doomsayer"], NPC, 20885 };
		{ GREY.."4) "..AtlasLocale["Wrath-Scryer Soccothrates"], NPC, 20886 };
		{ GREY.."5) "..AtlasLocale["Udalo"], NPC, 21962 };
		{ GREY.."6) "..AtlasLocale["Harbinger Skyriss"], NPC, 20912 };
		{ GREY..INDENT..AtlasLocale["Warden Mellichar"], NPC, 20904 };
		{ GREY..INDENT..AtlasLocale["Millhouse Manastorm"], NPC, 20977 };
	};
	TempestKeepBotanica = {
		ZoneName = { BabbleZone["Tempest Keep"]..": "..BabbleZone["The Botanica"], 3847 };
		Location = { BabbleZone["Netherstorm"], 3523 };
		LevelRange = "69-70";
		MinLevel = "68";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Bota"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Sha'tar"], FACTION, 935 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Warpforged Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30634 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Commander Sarannis"], NPC, 17976 };
		{ GREY.."2) "..AtlasLocale["High Botanist Freywinn"], NPC, 17975 };
		{ GREY.."3) "..AtlasLocale["Thorngrin the Tender"], NPC, 17978 };
		{ GREY.."4) "..AtlasLocale["Laj"], NPC, 17980 };
		{ GREY.."5) "..AtlasLocale["Warp Splinter"], NPC, 17977 };
	};
	TempestKeepMechanar = {
		ZoneName = { BabbleZone["Tempest Keep"]..": "..BabbleZone["The Mechanar"], 3849 };
		Location = { BabbleZone["Netherstorm"], 3523 };
		LevelRange = "68-70";
		MinLevel = "68";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Mech"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Sha'tar"], FACTION, 935 };
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Warpforged Key"].." ("..AtlasLocale["Heroic"]..")", ITEM, 30634 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Gatewatcher Gyro-Kill"], NPC, 19218 };
		{ GREY.."2) "..AtlasLocale["Gatewatcher Iron-Hand"], NPC, 19710 };
		{ GREY..INDENT..AtlasLocale["Cache of the Legion"], OBJECT, 184465 };
		{ GREY.."3) "..AtlasLocale["Mechano-Lord Capacitus"], NPC, 19219 };
		{ GREY..INDENT..AtlasLocale["Overcharged Manacell"], OBJECT, 185015 };
		{ GREY.."4) "..AtlasLocale["Nethermancer Sepethrea"], NPC, 19221 };
		{ GREY.."5) "..AtlasLocale["Pathaleon the Calculator"], NPC, 19220 };
	};
	TempestKeepTheEye = {
		ZoneName = { BabbleZone["Tempest Keep"]..": "..BabbleZone["The Eye"], 3842 };
		Location = { BabbleZone["Netherstorm"], 3523 };
		LevelRange = "70";
		MinLevel = "70";
		PlayerLimit = "25";
		Acronym = AtlasLocale["Eye"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Sha'tar"], FACTION, 935 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Al'ar <Phoenix God>"], NPC, 19514 };
		{ GREY.."2) "..AtlasLocale["Void Reaver"], NPC, 19516 };
		{ GREY.."3) "..AtlasLocale["High Astromancer Solarian"], NPC, 18805 };
		{ GREY.."4) "..AtlasLocale["Kael'thas Sunstrider <Lord of the Blood Elves>"], NPC, 19622 };
		{ GREY..INDENT..AtlasLocale["Thaladred the Darkener <Advisor to Kael'thas>"].." ("..AtlasLocale["Warrior"]..")", NPC, 20064 };
		{ GREY..INDENT..AtlasLocale["Master Engineer Telonicus <Advisor to Kael'thas>"].." ("..AtlasLocale["Hunter"]..")", NPC, 20063 };
		{ GREY..INDENT..AtlasLocale["Grand Astromancer Capernian <Advisor to Kael'thas>"].." ("..AtlasLocale["Mage"]..")", NPC, 20062 };
		{ GREY..INDENT..AtlasLocale["Lord Sanguinar <The Blood Hammer>"].." ("..AtlasLocale["Paladin"]..")", NPC, 20060 };
	};
	ZulAman = {
		ZoneName = { BabbleZone["Zul'Aman"], 3805 };
		Location = { BabbleZone["Ghostlands"], 3433 };
		LevelRange = "70";
		MinLevel = "68";
		PlayerLimit = "10";
		Acronym = AtlasLocale["ZA"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Harrison Jones"], NPC, 24358 };
		{ GREY.."1) "..AtlasLocale["Nalorakk <Bear Avatar>"], NPC, 23576 };
		{ GREY..INDENT..AtlasLocale["Tanzar"], NPC, 23790 };
		{ GREY..INDENT..AtlasLocale["The Map of Zul'Aman"], OBJECT, 186733 };
		{ GREY.."2) "..AtlasLocale["Akil'Zon <Eagle Avatar>"], NPC, 23574 };
		{ GREY..INDENT..AtlasLocale["Harkor"], NPC, 23999 };
		{ GREY.."3) "..AtlasLocale["Jan'Alai <Dragonhawk Avatar>"], NPC, 23578 };
		{ GREY..INDENT..AtlasLocale["Kraz"], NPC, 24024 };
		{ GREY.."4) "..AtlasLocale["Halazzi <Lynx Avatar>"], NPC, 23577 };
		{ GREY..INDENT..AtlasLocale["Ashli"], NPC, 24001 };
		{ GREY.."5) "..AtlasLocale["Zungam"], NPC, 23897 };
		{ GREY.."6) "..AtlasLocale["Hex Lord Malacrass"], NPC, 24239 };
		{ GREY..INDENT..AtlasLocale["Thurg"].." ("..AtlasLocale["Random"]..")", NPC, 24241 };
		{ GREY..INDENT..AtlasLocale["Gazakroth"].." ("..AtlasLocale["Random"]..")", NPC, 24244 };
		{ GREY..INDENT..AtlasLocale["Lord Raadan"].." ("..AtlasLocale["Random"]..")", NPC, 24243 };
		{ GREY..INDENT..AtlasLocale["Darkheart"].." ("..AtlasLocale["Random"]..")", NPC, 24246 };
		{ GREY..INDENT..AtlasLocale["Alyson Antille"].." ("..AtlasLocale["Random"]..")", NPC, 24240 };
		{ GREY..INDENT..AtlasLocale["Slither"].." ("..AtlasLocale["Random"]..")", NPC, 24242 };
		{ GREY..INDENT..AtlasLocale["Fenstalker"].." ("..AtlasLocale["Random"]..")", NPC, 24245 };
		{ GREY..INDENT..AtlasLocale["Koragg"].." ("..AtlasLocale["Random"]..")", NPC, 24247 };
		{ GREY.."7) "..AtlasLocale["Zul'jin"], NPC, 23863 };
		{ GREN.."1') "..AtlasLocale["Forest Frogs"], NPC, 24396 };
		{ GREN..INDENT..AtlasLocale["Kyren <Reagents>"], NPC, 24409 };
		{ GREN..INDENT..AtlasLocale["Gunter <Food Vendor>"], NPC, 24408 };
		{ GREN..INDENT..AtlasLocale["Adarrah"], NPC, 24405 };
		{ GREN..INDENT..AtlasLocale["Brennan"], NPC, 24453 };
		{ GREN..INDENT..AtlasLocale["Darwen"], NPC, 24407 };
		{ GREN..INDENT..AtlasLocale["Deez"], NPC, 24403 };
		{ GREN..INDENT..AtlasLocale["Galathryn"], NPC, 24404 };
		{ GREN..INDENT..AtlasLocale["Mitzi"], NPC, 24445 };
		{ GREN..INDENT..AtlasLocale["Mannuth"], NPC, 24397 };
	};	

--************************************************
-- Wrath of the Lich King Instances
--************************************************

	AhnKahet = {
		ZoneName = { BabbleZone["Ahn'kahet: The Old Kingdom"], 4494 };
		Location = { BabbleZone["Dragonblight"], 65 };
		LevelRange = "71-78";
		MinLevel = "68";
		PlayerLimit = "5";
		Acronym = AtlasLocale["AK, Kahet"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Elder Nadox"], NPC, 29309 };
		{ GREY.."2) "..AtlasLocale["Prince Taldaram"], NPC, 29308 };
		{ GREY.."3) "..AtlasLocale["Amanitar"].." ("..AtlasLocale["Heroic"]..")", NPC, 30258 };
		{ GREY.."4) "..AtlasLocale["Jedoga Shadowseeker"], NPC, 29310 };
		{ GREY.."5) "..AtlasLocale["Herald Volazj"], NPC, 29311 };
		{ GREY.."6) "..AtlasLocale["Ahn'kahet Brazier"] };
	};
	AzjolNerub = {
		ZoneName = { BabbleZone["Azjol-Nerub"], 3477 };
		Location = { BabbleZone["Dragonblight"], 65 };
		LevelRange = "70-77";
		MinLevel = "67";
		PlayerLimit = "5";
		Acronym = AtlasLocale["AN, Nerub"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Krik'thir the Gatewatcher"], NPC, 28684 };
		{ GREY..INDENT..AtlasLocale["Watcher Gashra"], NPC, 28730 };
		{ GREY..INDENT..AtlasLocale["Watcher Narjil"], NPC, 28729 };
		{ GREY..INDENT..AtlasLocale["Watcher Silthik"], NPC, 28731 };
		{ GREY.."2) "..AtlasLocale["Hadronox"], NPC, 28921 };
		{ GREY.."3) "..AtlasLocale["Elder Nurgen"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 30533 };
		{ GREY.."4) "..AtlasLocale["Anub'arak"], NPC, 29120 };
	};
	CoTOldStratholme = {
		ZoneName = { BabbleZone["Caverns of Time"]..": "..BabbleZone["The Culling of Stratholme"], 4100 };
		Location = { BabbleZone["Tanaris"], 440 };
		LevelRange = "78-80";
		MinLevel = "75";
		PlayerLimit = "5";
		Acronym = AtlasLocale["CoT-Strat"];
		{ PURP..AtlasLocale["Event"]..": "..AtlasLocale["The Culling of Stratholme"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"].." ("..AtlasLocale["Portal"]..")" };
		{ ORNG.."X) "..AtlasLocale["Scourge Invasion Points"] };
		{ ORNG..INDENT..AtlasLocale["Wave 5"]..": "..AtlasLocale["Meathook"], NPC, 26529 };
		{ ORNG..INDENT..AtlasLocale["Wave 10"]..": "..AtlasLocale["Salramm the Fleshcrafter"], NPC, 26530 };
		{ GREY.."1) "..AtlasLocale["Chromie"], NPC, 26527 };
		{ GREY.."2) "..AtlasLocale["Chromie"], NPC, 27915 };
		{ GREY.."3) "..AtlasLocale["Chrono-Lord Epoch"], NPC, 26532 };
		{ GREY.."4) "..AtlasLocale["Infinite Corruptor"].." ("..AtlasLocale["Heroic"]..")", NPC, 32273 };
		{ GREY..INDENT..AtlasLocale["Guardian of Time"], NPC, 32281 };
		{ GREY.."5) "..AtlasLocale["Mal'Ganis"], NPC, 26533 };
		{ GREY..INDENT..AtlasLocale["Chromie"], NPC, 30997 };
	};
	DrakTharonKeep = {
		ZoneName = { BabbleZone["Drak'Tharon Keep"], 4196 };
		Location = { BabbleZone["Grizzly Hills"], 394 };
		LevelRange = "72-78";
		MinLevel = "69";
		PlayerLimit = "5";
		Acronym = AtlasLocale["DTK"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Trollgore"], NPC, 26630 };
		{ GREY.."2) "..AtlasLocale["Kurzel"], NPC, 26664 };
		{ GREY.."3) "..AtlasLocale["Novos the Summoner"], NPC, 26631 };
		{ GREY.."4) "..AtlasLocale["Elder Kilias"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 30534 };
		{ GREY.."5) "..AtlasLocale["King Dred"], NPC, 27483 };
		{ GREY.."6) "..AtlasLocale["The Prophet Tharon'ja"], NPC, 26632 };
		{ GREY.."7) "..AtlasLocale["Drakuru's Brazier"] };
	};
	FHHallsOfReflection = {
		ZoneName = { BabbleSubZone["The Frozen Halls"]..": "..BabbleZone["Halls of Reflection"], 4820 };
		Location = { BabbleZone["Icecrown Citadel"], 4812 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "5";
		Acronym = AtlasLocale["HoR"]..", "..AtlasLocale["FH3"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Portal"].." ("..BabbleZone["Dalaran"]..")", ZONE, 4395 };
		{ GREY.."1) "..AtlasLocale["Lady Jaina Proudmoore"].." ("..AtlasLocale["Alliance"]..")", NPC, 37221 };
		{ GREY..INDENT..AtlasLocale["Archmage Koreln <Kirin Tor>"].." ("..AtlasLocale["Alliance"]..")", NPC, 37582 };
		{ GREY..INDENT..AtlasLocale["Lady Sylvanas Windrunner <Banshee Queen>"].." ("..AtlasLocale["Horde"]..")", NPC, 37223 };
		{ GREY..INDENT..AtlasLocale["Dark Ranger Loralen"].." ("..AtlasLocale["Horde"]..")", NPC, 37779 };
		{ GREY.."2) "..AtlasLocale["Falric"].." ("..AtlasLocale["Wave 5"]..")", NPC, 38112 };
		{ GREY.."3) "..AtlasLocale["Marwyn"].." ("..AtlasLocale["Wave 10"]..")", NPC, 38113 };
		{ GREY.."4) "..AtlasLocale["Wrath of the Lich King"].." ("..AtlasLocale["Event"]..")", NPC, 37226 };
		{ GREY..INDENT..AtlasLocale["The Captain's Chest"], OBJECT, 201710 };
	};
	FHPitOfSaron = {
		ZoneName = { BabbleSubZone["The Frozen Halls"]..": "..BabbleZone["Pit of Saron"], 4813 };
		Location = { BabbleZone["Icecrown Citadel"], 4812 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "5";
		Acronym = AtlasLocale["PoS"]..", "..AtlasLocale["FH2"];
		{ ORNG..AtlasLocale["Attunement Required"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Portal"].." ("..BabbleZone["Halls of Reflection"]..")", ZONE, 4820 };
		{ GREY.."1) "..AtlasLocale["Lady Jaina Proudmoore"].." ("..AtlasLocale["Alliance"]..")", NPC, 36993 };
		{ GREY..INDENT..AtlasLocale["Archmage Koreln <Kirin Tor>"].." ("..AtlasLocale["Alliance"]..")", NPC, 37582 };
		{ GREY..INDENT..AtlasLocale["Archmage Elandra <Kirin Tor>"].." ("..AtlasLocale["Alliance"]..")", NPC, 37774 };
		{ GREY..INDENT..AtlasLocale["Lady Sylvanas Windrunner <Banshee Queen>"].." ("..AtlasLocale["Horde"]..")", NPC, 36990 };
		{ GREY..INDENT..AtlasLocale["Dark Ranger Loralen"].." ("..AtlasLocale["Horde"]..")", NPC, 37779 };
		{ GREY..INDENT..AtlasLocale["Dark Ranger Kalira"].." ("..AtlasLocale["Horde"]..")", NPC, 37583 };
		{ GREY.."2) "..AtlasLocale["Forgemaster Garfrost"], NPC, 36494 };
		{ GREY..INDENT..AtlasLocale["Martin Victus"].." ("..AtlasLocale["Alliance"]..")", NPC, 37591 };
		{ GREY..INDENT..AtlasLocale["Gorkun Ironskull"].." ("..AtlasLocale["Horde"]..")", NPC, 37592 };
		{ GREY.."3) "..AtlasLocale["Krick and Ick"], NPC, 36477 };
		{ GREY.."4) "..AtlasLocale["Scourgelord Tyrannus"], NPC, 36658 };
		{ GREY..INDENT..AtlasLocale["Rimefang"], NPC, 36661 };
	};
	FHTheForgeOfSouls = {
		ZoneName = { BabbleSubZone["The Frozen Halls"]..": "..BabbleZone["The Forge of Souls"], 4809 };
		Location = { BabbleZone["Icecrown Citadel"], 4812 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "5";
		Acronym = AtlasLocale["FoS"]..", "..AtlasLocale["FH1"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Portal"].." ("..BabbleZone["Pit of Saron"]..")", ZONE, 4813 };
		{ GREY.."1) "..AtlasLocale["Lady Jaina Proudmoore"].." ("..AtlasLocale["Alliance"]..")", NPC, 37597 };
		{ GREY..INDENT..AtlasLocale["Archmage Koreln <Kirin Tor>"].." ("..AtlasLocale["Alliance"]..")", NPC, 37582 };
		{ GREY..INDENT..AtlasLocale["Archmage Elandra <Kirin Tor>"].." ("..AtlasLocale["Alliance"]..")", NPC, 37774 };
		{ GREY..INDENT..AtlasLocale["Lady Sylvanas Windrunner <Banshee Queen>"].." ("..AtlasLocale["Horde"]..")", NPC, 37596 };
		{ GREY..INDENT..AtlasLocale["Dark Ranger Loralen"].." ("..AtlasLocale["Horde"]..")", NPC, 37779 };
		{ GREY..INDENT..AtlasLocale["Dark Ranger Kalira"].." ("..AtlasLocale["Horde"]..")", NPC, 37583 };
		{ GREY.."2) "..AtlasLocale["Bronjahm <Godfather of Souls>"], NPC, 36497 };
		{ GREY.."3) "..AtlasLocale["Devourer of Souls"], NPC, 36502 };
	};
	Gundrak = {
		ZoneName = { BabbleZone["Gundrak"], 4375 };
		Location = { BabbleZone["Zul'Drak"], 66 };
		LevelRange = "76-80";
		MinLevel = "71";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Gun"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Exit"] };
		{ GREY.."1) "..AtlasLocale["Slad'ran <High Prophet of Sseratus>"], NPC, 29304 };
		{ GREY.."2) "..AtlasLocale["Drakkari Colossus"], NPC, 29307 };
		{ GREY.."3) "..AtlasLocale["Elder Ohanzee"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 30537 };
		{ GREY.."4) "..AtlasLocale["Moorabi <High Prophet of Mam'toth>"], NPC, 29305 };
		{ GREY.."5) "..AtlasLocale["Eck the Ferocious"].." ("..AtlasLocale["Heroic"]..", "..AtlasLocale["Summon"]..")", NPC, 29932 };
		{ GREY.."6) "..AtlasLocale["Gal'darah <High Prophet of Akali>"], NPC, 29306 };
	};
	IcecrownCitadelA = {
		ZoneName = { BabbleZone["Icecrown Citadel"].." [A] ("..AtlasLocale["Lower"]..")", 4812 };
		Location = { BabbleZone["Icecrown"], 210 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["IC"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Ashen Verdict"], FACTION, 1156 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Connection"] };
		{ BLUE.."C) "..AtlasLocale["To next map"] };
		{ GREY.."1) "..AtlasLocale["Lord Marrowgar"], NPC, 36612 };
		{ GREY.."2) "..AtlasLocale["Lady Deathwhisper"], NPC, 36855 };
		{ GREY.."3) "..AtlasLocale["Gunship Battle"].." ("..AtlasLocale["Alliance"]..")", OBJECT, 201873 };
		{ GREY.."4) "..AtlasLocale["Gunship Battle"].." ("..AtlasLocale["Horde"]..")", OBJECT, 201873 };
		{ GREY.."5) "..AtlasLocale["Deathbringer Saurfang"], NPC, 37813 };
		{ GREN.."1') "..BabbleSubZone["Light's Hammer"].." ("..AtlasLocale["Teleporter"]..")" };
		{ GREN.."2') "..BabbleSubZone["Oratory of the Damned"].." ("..AtlasLocale["Teleporter"]..")" };
		{ GREN.."3') "..BabbleSubZone["Rampart of Skulls"].." ("..AtlasLocale["Teleporter"]..", "..AtlasLocale["Lower"]..")" };
		{ GREN..INDENT..BabbleSubZone["Deathbringer's Rise"].." ("..AtlasLocale["Teleporter"]..", "..AtlasLocale["Upper"]..")" };
	};
	IcecrownCitadelB = {
		ZoneName = { BabbleZone["Icecrown Citadel"].." [B] ("..AtlasLocale["Upper"]..")", 4812 };
		Location = { BabbleZone["Icecrown"], 210 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["IC"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Ashen Verdict"], FACTION, 1156 };
		{ BLUE.."C) "..AtlasLocale["From previous map"] };
		{ BLUE.."D-H) "..AtlasLocale["Connection"] };
		{ BLUE.."I) "..AtlasLocale["To next map"] };
		{ GREY.."6) "..AtlasLocale["Festergut"], NPC, 36626 };
		{ GREY.."7) "..AtlasLocale["Rotface"], NPC, 36627 };
		{ GREY.."8) "..AtlasLocale["Professor Putricide"], NPC, 36678 };
		{ GREY.."9) "..AtlasLocale["Blood Prince Council"] };
		{ GREY..INDENT..AtlasLocale["Prince Keleseth"], NPC, 37972 };
		{ GREY..INDENT..AtlasLocale["Prince Taldaram"], NPC, 37973 };
		{ GREY..INDENT..AtlasLocale["Prince Valanar"], NPC, 37970 };
		{ GREY.."10) "..AtlasLocale["Blood-Queen Lana'thel"], NPC, 38004 };
		{ GREY.."11) "..AtlasLocale["Valithria Dreamwalker"], NPC, 36789 };
		{ GREY.."12) "..AtlasLocale["Sindragosa <Queen of the Frostbrood>"], NPC, 37755 };
		{ GREN.."4') "..AtlasLocale["Upper Spire"].." ("..AtlasLocale["Teleporter"]..")" };
		{ GREN.."5') "..AtlasLocale["Sindragosa's Lair"].." ("..AtlasLocale["Teleporter"]..")" };
	};
	IcecrownCitadelC = {
		ZoneName = { BabbleZone["Icecrown Citadel"].." [C] ("..BabbleSubZone["The Frozen Throne"]..")", 4812 };
		Location = { BabbleZone["Icecrown"], 210 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["IC"];
		{ ORNG..AtlasLocale["Reputation"]..": "..AtlasLocale["The Ashen Verdict"], FACTION, 1156 };
		{ BLUE.."I) "..AtlasLocale["From previous map"] };
		{ GREY.."13) "..AtlasLocale["The Lich King"], NPC, 36597 };
	};
	Naxxramas = {
		ZoneName = { BabbleZone["Naxxramas"], 3456 };
		Location = { BabbleZone["Dragonblight"], 65 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Nax"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Mr. Bigglesworth"].." ("..AtlasLocale["Wanders"]..")", NPC, 16998 };
		{ GREY..BabbleSubZone["The Construct Quarter"] };
		{ GREY..INDENT.."1) "..AtlasLocale["Patchwerk"], NPC, 16028 };
		{ GREY..INDENT.."2) "..AtlasLocale["Grobbulus"], NPC, 15931 };
		{ GREY..INDENT.."3) "..AtlasLocale["Gluth"], NPC, 15932 };
		{ GREY..INDENT.."4) "..AtlasLocale["Thaddius"], NPC, 15928 };
		{ ORNG..BabbleSubZone["The Arachnid Quarter"] };
		{ ORNG..INDENT.."1) "..AtlasLocale["Anub'Rekhan"], NPC, 15956 };
		{ ORNG..INDENT.."2) "..AtlasLocale["Grand Widow Faerlina"], NPC, 15953 };
		{ ORNG..INDENT.."3) "..AtlasLocale["Maexxna"], NPC, 15952 };
		{ _RED..BabbleSubZone["The Military Quarter"] };
		{ _RED..INDENT.."1) "..AtlasLocale["Instructor Razuvious"], NPC, 16061 };
		{ _RED..INDENT.."2) "..AtlasLocale["Gothik the Harvester"], NPC, 16060 };
		{ _RED..INDENT.."3) "..AtlasLocale["The Four Horsemen"] };
		{ _RED..INDENT..INDENT..AtlasLocale["Thane Korth'azz"], NPC, 16064 };
		{ _RED..INDENT..INDENT..AtlasLocale["Lady Blaumeux"], NPC, 16065 };
		{ _RED..INDENT..INDENT..AtlasLocale["Baron Rivendare"], NPC, 30549 };
		{ _RED..INDENT..INDENT..AtlasLocale["Sir Zeliek"], NPC, 16063 };
		{ _RED..INDENT..INDENT..AtlasLocale["Four Horsemen Chest"], OBJECT, 181366 };
		{ PURP..BabbleSubZone["The Plague Quarter"] };
		{ PURP..INDENT.."1) "..AtlasLocale["Noth the Plaguebringer"], NPC, 15954 };
		{ PURP..INDENT.."2) "..AtlasLocale["Heigan the Unclean"], NPC, 15936 };
		{ PURP..INDENT.."3) "..AtlasLocale["Loatheb"], NPC, 16011 };
		{ GREN..AtlasLocale["Frostwyrm Lair"] };
		{ GREN..INDENT.."1) "..AtlasLocale["Sapphiron"], NPC, 15989 };
		{ GREN..INDENT.."2) "..AtlasLocale["Kel'Thuzad"], NPC, 15990 };
	};
	ObsidianSanctum = {
		ZoneName = { BabbleSubZone["Chamber of the Aspects"]..": "..BabbleZone["The Obsidian Sanctum"], 4493 };
		Location = { BabbleZone["Dragonblight"], 65 };
		LevelRange = "80";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["OS"];
		{ ORNG..AtlasLocale["AKA"]..": "..AtlasLocale["Black Dragonflight Chamber"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Tenebron"], NPC, 30452 };
		{ GREY.."2) "..AtlasLocale["Shadron"], NPC, 30451 };
		{ GREY.."3) "..AtlasLocale["Vesperon"], NPC, 30449 };
		{ GREY.."4) "..AtlasLocale["Sartharion <The Onyx Guardian>"], NPC, 28860 };
	};
	OnyxiasLair = {
		ZoneName = { BabbleZone["Onyxia's Lair"], 2159 };
		Acronym = AtlasLocale["Ony"];
		Location = { BabbleZone["Dustwallow Marsh"], 15 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Onyxian Warders"], NPC, 12129 };
		{ GREY.."2) "..AtlasLocale["Whelp Eggs"] };
		{ GREY.."3) "..AtlasLocale["Onyxia"], NPC, 10184 };
	};
	RubySanctum = {
		ZoneName = { BabbleSubZone["Chamber of the Aspects"]..": "..BabbleZone["The Ruby Sanctum"], 4987 };
		Location = { BabbleZone["Dragonblight"], 65 };
		LevelRange = "80";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["RS"];
		{ ORNG..AtlasLocale["AKA"]..": "..AtlasLocale["Red Dragonflight Chamber"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Baltharus the Warborn"], NPC, 39751 };
		{ GREY.."2) "..AtlasLocale["Saviana Ragefire"], NPC, 39747 };
		{ GREY.."3) "..AtlasLocale["General Zarithrian"], NPC, 39746 };
		{ GREY.."4) "..AtlasLocale["Halion <The Twilight Destroyer>"], NPC, 39863 };		
	};
	TheEyeOfEternity = {
		ZoneName = { BabbleZone["The Nexus"]..": "..BabbleZone["The Eye of Eternity"], 4500 };
		Location = { BabbleZone["Borean Tundra"], 3537 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["TEoE"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Key to the Focusing Iris"], ITEM, 44582 };
		{ GREY.."1) "..AtlasLocale["Malygos"], NPC, 28859 };
	};
	TheNexus = {
		ZoneName = { BabbleZone["The Nexus"]..": "..BabbleZone["The Nexus"], 4120 };
		Location = { BabbleZone["Borean Tundra"], 3537 };
		LevelRange = "70-75";
		MinLevel = "66";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Nex, Nexus"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Berinand's Research"], OBJECT, 192788 };
		{ GREY..INDENT..AtlasLocale["Commander Stoutbeard"].." ("..AtlasLocale["Horde"]..", "..AtlasLocale["Heroic"]..")", NPC, 26796 };
		{ GREY..INDENT..AtlasLocale["Commander Kolurg"].." ("..AtlasLocale["Alliance"]..", "..AtlasLocale["Heroic"]..")", NPC, 26798 };
		{ GREY.."2) "..AtlasLocale["Grand Magus Telestra"], NPC, 26731 };
		{ GREY.."3) "..AtlasLocale["Anomalus"], NPC, 26763 };
		{ GREY.."4) "..AtlasLocale["Elder Igasho"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 30536 };
		{ GREY.."5) "..AtlasLocale["Ormorok the Tree-Shaper"], NPC, 26794 };
		{ GREY.."6) "..AtlasLocale["Keristrasza"], NPC, 26723 };
	};
	TheOculus = {
		ZoneName = { BabbleZone["The Nexus"]..": "..BabbleZone["The Oculus"], 4228 };
		Location = { BabbleZone["The Nexus"], 4120 };
		LevelRange = "78-80";
		MinLevel = "75";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Ocu"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Portal"] };
		{ GREY.."1) "..AtlasLocale["Drakos the Interrogator"], NPC, 27654 };
		{ GREY.."2) "..AtlasLocale["Varos Cloudstrider <Azure-Lord of the Blue Dragonflight>"], NPC, 27447 };
		{ GREY.."3) "..AtlasLocale["Mage-Lord Urom"], NPC, 27655 };
		{ GREY.."4) "..AtlasLocale["Ley-Guardian Eregos"], NPC, 27656 };
		{ GREY.."5) "..AtlasLocale["Cache of Eregos"], OBJECT, 191349};
		{ GREN.."1') "..AtlasLocale["Centrifuge Construct"], NPC, 27641 };
	};
	TrialOfTheChampion = {
		ZoneName = { AtlasLocale["Crusaders' Coliseum"]..": "..BabbleZone["Trial of the Champion"], 4723 };
		Location = { BabbleZone["Icecrown"], 210 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "5";
		Acronym = AtlasLocale["Champ"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Grand Champions"] };
		{ GREY..INDENT..AtlasLocale["Champions of the Alliance"] };
		{ GREY..INDENT..INDENT..AtlasLocale["Marshal Jacob Alerius"], NPC, 34705 };
		{ GREY..INDENT..INDENT..AtlasLocale["Ambrose Boltspark"], NPC, 34702 };
		{ GREY..INDENT..INDENT..AtlasLocale["Colosos"], NPC, 34701 };
		{ GREY..INDENT..INDENT..AtlasLocale["Jaelyne Evensong"], NPC, 34657 };
		{ GREY..INDENT..INDENT..AtlasLocale["Lana Stouthammer"], NPC, 34703 };
		{ GREY..INDENT..AtlasLocale["Champions of the Horde"] };
		{ GREY..INDENT..INDENT..AtlasLocale["Mokra the Skullcrusher"], NPC, 35572 };
		{ GREY..INDENT..INDENT..AtlasLocale["Eressea Dawnsinger"], NPC, 35569 };
		{ GREY..INDENT..INDENT..AtlasLocale["Runok Wildmane"], NPC, 35571 };
		{ GREY..INDENT..INDENT..AtlasLocale["Zul'tore"], NPC, 35570 };
		{ GREY..INDENT..INDENT..AtlasLocale["Deathstalker Visceri"], NPC, 35617 };
		{ GREY..INDENT..AtlasLocale["Eadric the Pure <Grand Champion of the Argent Crusade>"], NPC, 35119 };
		{ GREY..INDENT..AtlasLocale["Argent Confessor Paletress"], NPC, 34928 };
		{ GREY..INDENT..AtlasLocale["The Black Knight"], NPC, 35451 };
	};
	TrialOfTheCrusader = {
		ZoneName = { AtlasLocale["Crusaders' Coliseum"]..": "..BabbleZone["Trial of the Crusader"], 4722 };
		Location = { BabbleZone["Icecrown"], 210 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Crus"];
		{ ORNG..AtlasLocale["Heroic: Trial of the Grand Crusader"] };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..AtlasLocale["Cavern Entrance"] };
		{ GREY.."1) "..AtlasLocale["Northrend Beasts"] };
		{ GREY..INDENT..INDENT..AtlasLocale["Gormok the Impaler"], NPC, 34796 };
		{ GREY..INDENT..INDENT..AtlasLocale["Acidmaw"], NPC, 35144 };
		{ GREY..INDENT..INDENT..AtlasLocale["Dreadscale"], NPC, 34799 };
		{ GREY..INDENT..INDENT..AtlasLocale["Icehowl"], NPC, 34797 };
		{ GREY..INDENT..AtlasLocale["Lord Jaraxxus"], NPC, 34780 };
		{ GREY..INDENT..AtlasLocale["Faction Champions"] };
		{ GREY..INDENT..AtlasLocale["Twin Val'kyr"] };
		{ GREY..INDENT..INDENT..AtlasLocale["Fjola Lightbane"], NPC, 34497 };
		{ GREY..INDENT..INDENT..AtlasLocale["Eydis Darkbane"], NPC, 34496 };
		{ GREY.."2) "..AtlasLocale["Anub'arak"], NPC, 34564 };
	};
	UlduarA = {
		ZoneName = { BabbleZone["Ulduar"].." [A] ("..AtlasLocale["The Siege"]..")", 4273 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Uldu"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE.."B) "..BabbleSubZone["The Antechamber"] };
		{ ORNG.."A') "..AtlasLocale["Tower of Life"] };
		{ ORNG.."B') "..AtlasLocale["Tower of Flame"] };
		{ ORNG.."C') "..AtlasLocale["Tower of Frost"] };
		{ ORNG.."D') "..AtlasLocale["Tower of Storms"] };
		{ GREY.."1) "..AtlasLocale["Flame Leviathan"], NPC, 33113 };
		{ GREY.."2) "..AtlasLocale["Razorscale"].." ("..AtlasLocale["Optional"]..")", NPC, 33186 };
		{ GREY.."3) "..AtlasLocale["Ignis the Furnace Master"].." ("..AtlasLocale["Optional"]..")", NPC, 33118 };
		{ GREY.."4) "..AtlasLocale["XT-002 Deconstructor"], NPC, 33293 };
		{ GREN.."1') "..BabbleSubZone["Expedition Base Camp"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
		{ GREN.."2') "..BabbleSubZone["Formation Grounds"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
		{ GREN.."3') "..BabbleSubZone["The Colossal Forge"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
		{ GREN.."4') "..BabbleSubZone["The Scrapyard"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
	};
	UlduarB = {
		ZoneName = { BabbleZone["Ulduar"].." [B] ("..BabbleSubZone["The Antechamber"]..")", 4273 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Uldu"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["Celestial Planetarium Key"], ITEM, 45796 };
		{ BLUE.."B) "..AtlasLocale["The Siege"] };
		{ BLUE.."C) "..AtlasLocale["The Keepers"] };
		{ GREY.."5) "..AtlasLocale["Assembly of Iron"].." ("..AtlasLocale["Optional"]..")" };
		{ GREY..INDENT..AtlasLocale["Steelbreaker"], NPC, 32867 };
		{ GREY..INDENT..AtlasLocale["Runemaster Molgeim"], NPC, 32867 };
		{ GREY..INDENT..AtlasLocale["Stormcaller Brundir"], NPC, 32867 };
		{ GREY.."6) "..AtlasLocale["Prospector Doren"], NPC, 33956 };
		{ GREY..INDENT..AtlasLocale["Archivum Console"], OBJECT, 194555 };
		{ GREY.."7) "..AtlasLocale["Kologarn"], NPC, 32930 };
		{ GREY.."8) "..AtlasLocale["Algalon the Observer"].." ("..AtlasLocale["Optional"]..")" };
		{ GREN.."5') "..BabbleSubZone["The Antechamber"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
	};
	UlduarC = {
		ZoneName = { BabbleZone["Ulduar"].." [C] ("..AtlasLocale["The Keepers"]..")", 4273 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Uldu"];
		{ BLUE.."C) "..BabbleSubZone["The Antechamber"] };
		{ BLUE.."D) "..BabbleSubZone["The Spark of Imagination"] };
		{ BLUE.."E) "..BabbleSubZone["The Descent into Madness"] };
		{ GREY.."9) "..AtlasLocale["Auriaya"].." ("..AtlasLocale["Optional"]..")", NPC, 33515 };
		{ GREY.."10) "..AtlasLocale["Hodir"], NPC, 32845 };
		{ GREY.."11) "..AtlasLocale["Thorim"], NPC, 32865 };
		{ GREY.."12) "..AtlasLocale["Freya"], NPC, 32906 };
		{ GREN.."6') "..BabbleSubZone["The Shattered Walkway"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
		{ GREN.."7') "..BabbleSubZone["The Conservatory of Life"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
	};
	UlduarD = {
		ZoneName = { BabbleZone["Ulduar"].." [D] ("..BabbleSubZone["The Spark of Imagination"]..")", 4273 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Uldu"];
		{ BLUE.."D) "..AtlasLocale["The Keepers"] };
		{ GREY.."13) "..AtlasLocale["Mimiron"], NPC, 33412 };
		{ GREN.."8') "..BabbleSubZone["The Spark of Imagination"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
	};
	UlduarE = {
		ZoneName = { BabbleZone["Ulduar"].." [E] ("..BabbleSubZone["The Descent into Madness"]..")", 4273 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["Uldu"];
		{ BLUE.."E) "..AtlasLocale["The Keepers"] };
		{ GREY.."14) "..AtlasLocale["General Vezax"], NPC, 33271 };
		{ GREY.."15) "..AtlasLocale["Yogg-Saron"], NPC, 33288 };
		{ GREN.."9') "..BabbleSubZone["The Prison of Yogg-Saron"].." ("..AtlasLocale["Teleporter"]..")", OBJECT, 194569 };
	};
	UlduarHallsofLightning = {
		ZoneName = { BabbleZone["Ulduar"]..": "..BabbleZone["Halls of Lightning"], 4272 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "78-80";
		MinLevel = "75";
		PlayerLimit = "5";
		Acronym = AtlasLocale["HoL"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["General Bjarngrim"].." ("..AtlasLocale["Wanders"]..")", NPC, 28586 };
		{ GREY.."2) "..AtlasLocale["Volkhan"], NPC, 28587 };
		{ GREY.."3) "..AtlasLocale["Ionar"], NPC, 28546 };
		{ GREY.."4) "..AtlasLocale["Loken"], NPC, 28923 };
	};
	UlduarHallsofStone = {
		ZoneName = { BabbleZone["Ulduar"]..": "..BabbleZone["Halls of Stone"], 4264 };
		Location = { BabbleZone["The Storm Peaks"], 67 };
		LevelRange = "75-80";
		MinLevel = "72";
		PlayerLimit = "5";
		Acronym = AtlasLocale["HoS"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Elder Yurauk"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 30535 };
		{ GREY.."2) "..AtlasLocale["Krystallus"], NPC, 27977 };
		{ GREY.."3) "..AtlasLocale["Maiden of Grief"], NPC, 27975 };
		{ GREY.."4) "..AtlasLocale["Brann Bronzebeard"], NPC, 28070 };
		{ GREY.."5) "..AtlasLocale["Tribunal Chest"], OBJECT, 190586 };
		{ GREY.."6) "..AtlasLocale["Sjonnir the Ironshaper"], NPC, 27978 };
	};
	UtgardeKeep = {
		ZoneName = { BabbleZone["Utgarde Keep"]..": "..BabbleZone["Utgarde Keep"], 206 };
		Location = { BabbleZone["Howling Fjord"], 495 };
		LevelRange = "68-75";
		MinLevel = "65";
		PlayerLimit = "5";
		Acronym = AtlasLocale["UK, Keep"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Dark Ranger Marrah"], NPC, 24137 };
		{ BLUE.."B-C) "..AtlasLocale["Connection"] };
		{ GREY.."1) "..AtlasLocale["Prince Keleseth <The San'layn>"], NPC, 23953 };
		{ GREY.."2) "..AtlasLocale["Elder Jarten"].." ("..AtlasLocale["Lunar Festival"]..", "..AtlasLocale["Lower"]..")", NPC, 30531 };
		{ GREY.."3) "..AtlasLocale["Dalronn the Controller"], NPC, 24201 };
		{ GREY..INDENT..AtlasLocale["Skarvald the Constructor"], NPC, 24200 };
		{ GREY.."4) "..AtlasLocale["Ingvar the Plunderer"], NPC, 23980 };
	};
	UtgardePinnacle = {
		ZoneName = { BabbleZone["Utgarde Keep"]..": "..BabbleZone["Utgarde Pinnacle"], 1196 };
		Location = { BabbleZone["Utgarde Keep"], 206 };
		LevelRange = "78-80";
		MinLevel = "75";
		PlayerLimit = "5";
		Acronym = AtlasLocale["UP, Pinn"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ BLUE..INDENT..AtlasLocale["Brigg Smallshanks"], NPC, 30871 };
		{ GREY.."1) "..AtlasLocale["Svala Sorrowgrave"], NPC, 26668 };
		{ GREY.."2) "..AtlasLocale["Gortok Palehoof"], NPC, 26687 };
		{ GREY.."3) "..AtlasLocale["Skadi the Ruthless"], NPC, 26693 };
		{ GREY.."4) "..AtlasLocale["Elder Chogan'gada"].." ("..AtlasLocale["Lunar Festival"]..")", NPC, 30538 };
		{ GREY.."5) "..AtlasLocale["King Ymiron"], NPC, 26861 };
	};
	VaultOfArchavon = {
		ZoneName = { BabbleZone["Vault of Archavon"], 4603 };
		Location = { BabbleZone["Wintergrasp"], 4197 };
		LevelRange = "80+";
		MinLevel = "80";
		PlayerLimit = "10/25";
		Acronym = AtlasLocale["VoA"];
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Archavon the Stone Watcher"], NPC, 31125 };
		{ GREY.."2) "..AtlasLocale["Emalon the Storm Watcher"], NPC, 33993 };
		{ GREY.."3) "..AtlasLocale["Koralon the Flame Watcher"], NPC, 35013 };
		{ GREY.."4) "..AtlasLocale["Toravon the Ice Watcher"], NPC, 38433 };
	};
	VioletHold = {
		ZoneName = { BabbleZone["The Violet Hold"], 4415 };
		Location = { BabbleZone["Dalaran"], 4395 };
		LevelRange = "73-79";
		MinLevel = "70";
		PlayerLimit = "5";
		Acronym = AtlasLocale["VH"];
		{ ORNG..AtlasLocale["Key"]..": "..AtlasLocale["The Violet Hold Key"], ITEM, 42482 };
		{ BLUE.."A) "..AtlasLocale["Entrance"] };
		{ GREY.."1) "..AtlasLocale["Erekem"].." ("..AtlasLocale["Random"]..")", NPC, 29315 };
		{ GREY.."2) "..AtlasLocale["Zuramat the Obliterator"].." ("..AtlasLocale["Upper"]..", "..AtlasLocale["Random"]..")", NPC, 29314 };
		{ GREY..INDENT..AtlasLocale["Xevozz"].." ("..AtlasLocale["Lower"]..", "..AtlasLocale["Random"]..")", NPC, 29266 };
		{ GREY.."3) "..AtlasLocale["Ichoron"].." ("..AtlasLocale["Random"]..")", NPC, 29313 };
		{ GREY.."4) "..AtlasLocale["Moragg"].." ("..AtlasLocale["Random"]..")", NPC, 29316 };
		{ GREY.."5) "..AtlasLocale["Lavanthor"].." ("..AtlasLocale["Random"]..")", NPC, 29312 };
		{ GREY.."6) "..AtlasLocale["Cyanigosa"].." ("..AtlasLocale["Wave 18"]..")", NPC, 31134 };
	};
};