-- CREATION DATE: 01-05-2009 --
-- MODIFIED DATE: 14-08-2009 --
-- Vilm -- VludsItemLevelMod
------------------------------------------------------------------------------------------------------

VilmPrefix = "Item Level "

------------------------------------------------------------------------------------------------------
-- OnTooltipSetItem
local function VilmOnTooltipSetItem(oTip, ...)
	local sName, sLink = oTip:GetItem()
	if sLink then
		local _, _, _, iLevel = GetItemInfo(sLink)
		if iLevel ~= nil then
			oTip:AddLine(VilmPrefix .. iLevel)
			oTip:Show()
		end
	end
end

------------------------------------------------------------------------------------------------------
-- Initialise
local function VilmInitialise()
	GameTooltip:HookScript("OnTooltipSetItem", VilmOnTooltipSetItem)
	ItemRefTooltip:HookScript("OnTooltipSetItem", VilmOnTooltipSetItem)
	ShoppingTooltip1:HookScript("OnTooltipSetItem", VilmOnTooltipSetItem)
	ShoppingTooltip2:HookScript("OnTooltipSetItem", VilmOnTooltipSetItem)
	ShoppingTooltip3:HookScript("OnTooltipSetItem", VilmOnTooltipSetItem)
end

-- Run Init
VilmInitialise()

------------------------------------------------------------------------------------------------------
